--[[
The naming system uses a three digit system to represent the vector, in x, y, z
We need to be able to use negative numbers in the vectors, so we'll use the following:
0 = -1
1 = 0
2 = 1
So a card that has no movement would be 'rob_opr_base:inst_111'
]]

minetest.register_craftitem('rob_opr_base:inst_011', {
   description = 'Move West 1 space',
   inventory_image = 'rob_opr_base_pc_w.png',
   vector = {x=-1, y=0, z=0},
   stack_max = 1,
   groups = {not_in_creative_inventory = 1}
})

minetest.register_craftitem('rob_opr_base:inst_211', {
   description = 'Move East 1 space',
   inventory_image = 'rob_opr_base_pc_e.png',
   vector = {x=1, y=0, z=0},
   stack_max = 1,
   groups = {not_in_creative_inventory = 1}
})

minetest.register_craftitem('rob_opr_base:inst_110', {
   description = 'Move South 1 space',
   inventory_image = 'rob_opr_base_pc_s.png',
   vector = {x=0, y=0, z=-1},
   stack_max = 1,
   groups = {not_in_creative_inventory = 1}
})

minetest.register_craftitem('rob_opr_base:inst_112', {
   description = 'Move North 1 space',
   inventory_image = 'rob_opr_base_pc_n.png',
   vector = {x=0, y=0, z=1},
   stack_max = 1,
   groups = {not_in_creative_inventory = 1}
})

minetest.register_craftitem('rob_opr_base:inst_212', {
   description = 'Move North East 1 space.',
   inventory_image = 'rob_opr_base_pc_ne.png',
   vector = {x=1, y=0, z=1},
   stack_max = 1,
   groups = {not_in_creative_inventory = 1}
})

minetest.register_craftitem('rob_opr_base:inst_210', {
   description = 'Move South East 1 space',
   inventory_image = 'rob_opr_base_pc_se.png',
   vector = {x=1, y=0, z=-1},
   stack_max = 1,
   groups = {not_in_creative_inventory = 1}
})

minetest.register_craftitem('rob_opr_base:inst_012', {
   description = 'Move North West 1 space',
   inventory_image = 'rob_opr_base_pc_nw.png',
   vector = {x=-1, y=0, z=1},
   stack_max = 1,
   groups = {not_in_creative_inventory = 1}
})

minetest.register_craftitem('rob_opr_base:inst_010', {
   description = 'Move South West 1 space',
   inventory_image = 'rob_opr_base_pc_sw.png',
   vector = {x=-1, y=0, z=-1},
   stack_max = 1,
   groups = {not_in_creative_inventory = 1}
})

local cards = {'rob_opr_base:inst_112', 'rob_opr_base:inst_110', 'rob_opr_base:inst_211', 'rob_opr_base:inst_011', 'rob_opr_base:inst_212', 'rob_opr_base:inst_210', 'rob_opr_base:inst_012', 'rob_opr_base:inst_010'}

local program_cards = minetest.create_detached_inventory('program_cards', {
   allow_take = function(inv, listname, index, stack, player2)
      return -1
   end,
   allow_put = function(inv)
      return 0
   end,
})
program_cards:set_size('main', 24)
program_cards:set_list('main', cards)

local trash = minetest.create_detached_inventory('trash', {
   allow_put = function(inv, listname, index, stack, player)
      return stack:get_count()
   end,
   on_put = function(inv, listname)
      inv:set_list(listname, {})
   end,
})

trash:set_size('main', 1)
