-- Easy puzzles, more for training purposes than anything.

minetest.register_node('rob_opr_base:path_0_start', {
   description = 'Robot starts above this node',
   paramtype = 'light',
   tiles = {{name='rob_opr_base_path_0.png^rob_opr_base_path_start_2.png', align_style='world', scale=2}, {name='rob_opr_base_path_0_side.png', align_style='world', scale=2}},
   groups = {oddly_breakable_by_hand = 3},
   on_punch = function(pos, node, puncher)
      local name = puncher:get_player_name()
      local above_pos = minetest.pos_to_string(vector.add(pos, {x=0, y=1, z=0}))
      minetest.chat_send_player(name, 'The position is '..above_pos..'.')
   end
})

minetest.register_node('rob_opr_base:path_0', {
   description = 'Robot should travel on this node.',
   tiles = {{name='rob_opr_base_path_0.png', align_style='world', scale=2}, {name='rob_opr_base_path_0_side.png', align_style='world', scale=2}},
   groups = {oddly_breakable_by_hand = 3}
})

minetest.register_node('rob_opr_base:path_0_end', {
   description = 'Robot should end above this node.',
   tiles = {{name='rob_opr_base_path_0.png^rob_opr_base_path_end_2.png', align_style='world', scale=2}, {name='rob_opr_base_path_0_side.png', align_style='world', scale=2}},
   groups = {oddly_breakable_by_hand = 3, path_end = 1},
})

-- Medium difficulty puzzles.

minetest.register_node('rob_opr_base:path_1_start', {
   description = 'Robot starts above this node',
   paramtype = 'light',
   tiles = {{name='rob_opr_base_path_1_top.png^rob_opr_base_path_start_8.png', align_style='world', scale=8}, {name='rob_opr_base_path_1_side.png', align_style='world', scale=8}},
   groups = {oddly_breakable_by_hand = 3},
   on_punch = function(pos, node, puncher)
      local name = puncher:get_player_name()
      local above_pos = minetest.pos_to_string(vector.add(pos, {x=0, y=1, z=0}))
      minetest.chat_send_player(name, 'The position is '..above_pos..'.')
   end
})

minetest.register_node('rob_opr_base:path_1', {
   description = 'Robot should travel on this node.',
   tiles = {{name='rob_opr_base_path_1_top.png', align_style='world', scale=8}, {name='rob_opr_base_path_1_side.png', align_style='world', scale=8}},
   groups = {oddly_breakable_by_hand = 3}
})

minetest.register_node('rob_opr_base:path_1_end', {
   description = 'Robot should end above this node.',
   tiles = {{name='rob_opr_base_path_1_top.png^rob_opr_base_path_end_8.png', align_style='world', scale=8}, {name='rob_opr_base_path_1_side.png', align_style='world', scale=8}},
   groups = {oddly_breakable_by_hand = 3, path_end = 1},
})
