--[[Callbacks for nodes.
_on_use = function(pos, name) --Use the item, toggle switched, view formspecs, open doors. etc.
   do something, run a function, etc.
end,
_on_inspect = function(pos, name)--This should either show a formspec with an image or just return text.
   minetest.chat_send_player(name, '[Looks like a fairly sturdy rail.]')
end,
_on_report = function(pos, name) --Report to the CO, he can be snarky at times.
   minetest.chat_send_player(name, 'Sorry, why did you think this was important, focus.')
end,
_on_take = function(pos, name, player) --Take the item into inventory or let the player know they can't take it. Maybe have some chance rating or check for items in the players hand.
   minetest.chat_send_player(name, '[The railing is firmly bolted to the floor.]')
end

Invoke the menu in the on_rightclick function like this.
on_rightclick = function(pos, node, clicker)
   local name = clicker:get_player_name()
   rob_opr_base.act_menu[name] = pos
   minetest.show_formspec(name, 'action_menu', rob_opr_base.action_menu('1111'))
end,
--]]
--Buttons should be greyed out and made into non exit buttons if the value is '0'

--inspect
--Pickup
--Report
--Use
--Exit

--
function rob_opr_base.action_menu(num)
   local a, b, c, d
   local a_button = ''
   local b_button = ''
   local c_button = ''
   local d_button = ''
   if num then
      a = string.sub(num, 1, 1)
      b = string.sub(num, 2, 2)
      c = string.sub(num, 3, 3)
      d = string.sub(num, 4, 4)
   end
   local formspec =
      'formspec_version[6]'..
      'size[4,6.5]'..
      'position[.125,.75]'..
      'no_prepend[]'..
      'bgcolor[#00000000;false]'..
      'background[0,0;4,6.5;rob_opr_base_act_menu_bg.png]'..
      'style_type[image_button;textcolor=white;font_size=*2]'..
      'style_type[image_button_exit;textcolor=white]'..
      'style[nil;textcolor=red]'
   if a == '0' then
      formspec = formspec..'image_button[.25,.25;3.5,1;rob_opr_base_act_menu_button.png;nil;Inspect;;false]'
   else
      formspec = formspec..'image_button[.25,.25;3.5,1;rob_opr_base_act_menu_button.png;inspect;Inspect;;false]'
   end
   if b == '0' then
      formspec = formspec..'image_button[.25,1.5;3.5,1;rob_opr_base_act_menu_button.png;nil;Pick Up;;false]'
   else
      formspec = formspec..'image_button[.25,1.5;3.5,1;rob_opr_base_act_menu_button.png;steal;Pick Up;;false]'
   end
   if c == '0' then
      formspec = formspec..'image_button[.25,2.75;3.5,1;rob_opr_base_act_menu_button.png;nil;Report;;false]'
   else
      formspec = formspec..'image_button[.25,2.75;3.5,1;rob_opr_base_act_menu_button.png;report;Report;;false]'
   end
   if d == '0' then
      formspec = formspec..'image_button[.25,4;3.5,1;rob_opr_base_act_menu_button.png;nil;Use;;false]'
   else
      formspec = formspec..'image_button[.25,4;3.5,1;rob_opr_base_act_menu_button.png;use;Use;;false]'
   end
   formspec = formspec..'image_button_exit[.25,5.25;3.5,1;rob_opr_base_act_menu_button.png;;Exit;;false]'
   return formspec
end

local snide_remarks = {
   '{How did you get this job?}',
   '{Dude seriously.}',
   '{Come on now.}',
   '{It is what it is.}',
   "{Your intelligence must be a closely guarded secret.}",
   "{Did you take a course in being oblivious, or does it come naturally?}",
   "{You're not stupid; you just have bad luck thinking.}",
   "{I would explain why this is unimportant, but I'm afraid science hasn't advanced enough to cover that gap in your understanding.}",
   "{Are you always this slow, or are you making a special effort today?}",
   "{I'm trying to imagine you with a personality.}",
   "{It's impressive that you're not afraid to be yourself, no matter how unbearable that self may be.}",
   "{Do you have a black belt in stupidity?}",
   "{Is there an app I can download to make you stop bothering me?}",
   "{I envy people who haven't met you.}",
   "{You're like a Monday in human form.}",
   "{I'm sorry, did I roll my eyes out loud?}",
   "{Some people bring joy wherever they go; you bring joy whenever you leave.}",
   "{Had I know you were going to be such a pain I would have just done this myself.}",
   "{Just when I think you couldn't let me down more, you surprise me.}"
}

minetest.register_on_player_receive_fields(function(player, formname, fields)
   if formname == 'action_menu' then
      local name = player:get_player_name()
      local pos = rob_opr_base.act_menu[name]
      local node = minetest.get_node(pos)
      local def = minetest.registered_nodes[node.name]
      if fields.inspect then
         minetest.close_formspec(name, 'action_menu')
         local window_info = minetest.get_player_window_information(player:get_player_name())
         print(dump(window_info))
         if def._on_inspect then
            def._on_inspect(pos, name)
         else
            minetest.chat_send_player(name, minetest.colorize('#28b928', '[Nothing of interest here.]'))
         end
      elseif fields.steal then
         minetest.close_formspec(name, 'action_menu')
         if def._on_take then
            def._on_take(pos, name, player)
         else
            minetest.chat_send_player(name, minetest.colorize('#ff0000', '<You are unable to take this item.>'))
         end
      elseif fields.report then
         minetest.close_formspec(name, 'action_menu')
         if def._on_report then
            def._on_report(pos, name)
         else
            minetest.chat_send_player(name, minetest.colorize('#49adff', rob_opr_base.random_chat(snide_remarks)))
            rob_opr_base.adjust_anger(name, 2)
         end
      elseif fields.use then
         --minetest.close_formspec(name, 'action_menu') A race condition prevents this from opening a formspec in this callback.
         if def._on_use then
            def._on_use(pos, name, player)
         else
            minetest.chat_send_player(name, minetest.colorize('#cb00be', '|There doesn\'t seem to be any way to use this.|'))
            minetest.close_formspec(name, 'action_menu')
         end
      end
   end
end
)
