minetest.register_entity('rob_opr_base:robot_2', {
   initial_properties = {
      visual = 'mesh',
      mesh = 'rob_opr_base_robot_2.obj',
      visual_size = {x=10, y=10},
      physical = true,
      collisionbox = {-.375, -.5, -.475, .375, .1875, .475},
      textures = {'rob_opr_base_robot_2.png'},
      automatic_face_movement_dir = 0.0,
   },

   on_activate = function(self, staticdata, dtime_s)
      local data = minetest.deserialize(staticdata)
      if data then
         self.sequence = data.sequence
         self.node_timer = data.node_timer
         self.owner = data.owner
         self.step = data.step
      end
   end,

   get_staticdata = function(self)
      local data ={}
      data.node_timer = self.node_timer
      data.sequence = self.sequence
      data.owner = self.owner
      data.step = self.step
      return minetest.serialize(data)
   end,

   on_step = function(self, dtime, moveresults)
      self.node_timer = (self.node_timer or 0) + dtime
      if self.node_timer > 1 then
         self.node_timer = 0
         if self.step < 61 then
            local hack = vector.round(self.object:get_pos()) --This gets the POS of the robot and rounds it to align with the world.
            self.object:move_to(hack) --This sets the entity to be grid aligned.
         end
         local vel = self.sequence[self.step]
         if vel then
            self.object:set_velocity(vel)
            self.step = self.step + 1
         end
         local pos = vector.round(self.object:get_pos())
         local below_pos = vector.subtract(pos, {x=0, y=1, z=0})
         local below_node = minetest.get_node(below_pos).name
         if minetest.get_item_group(below_node, 'path_end') > 0 then
            minetest.chat_send_player(self.owner, 'yay, the robot made it to the end.')
            rob_opr_base.fireworks(pos)
            self.object:set_velocity({x=0, y=2, z=0})
            self.step = 99
            minetest.after(2, function()
               self.object:remove()
            end)
         elseif below_node == 'air' then
            if self.step < 61 then
               minetest.chat_send_player(self.owner, 'Try and keep the robot on the path next time.')
               self.step = 99
               self.object:set_velocity({x=0, y=-9.8, z=0})
            end
         elseif below_node == 'rob_opr_base:void' then
            local pos = vector.round(self.object:get_pos())
            minetest.chat_send_player(self.owner, 'The robot was vaporized')
            rob_opr_base.vaporize(pos)
            self.object:remove()
         end
      end
      if moveresults.collides then
         local hit_object = moveresults.collisions[1] and moveresults.collisions[1].type == 'object'
         if hit_object then
            local bump = moveresults.collisions[1].object
            local velocity = moveresults.collisions[1].old_velocity
            bump:set_velocity(velocity)
         end
         local hit_node = moveresults.collisions[1] and moveresults.collisions[1].type == 'node'
         if hit_node then
            if self.step < 61 then
               minetest.chat_send_player(self.owner, 'The robot hit a node.')
            --local pos = vector.round(self.object:get_pos())
            --minetest.set_node(pos, {name='rob_opr_base:robot_broken'})
            --local timer = minetest.get_node_timer(pos)
            --timer:start(10)
            --self.object:remove()
            end
         end
      end
   end,

   on_punch = function(self, puncher)
      local pos = self.object:get_pos()
      local name = puncher:get_player_name()
      minetest.chat_send_player(name, (minetest.colorize('#49adff', '{Excellent work agent, now make an escape. I\'m sending a dropship to pick you up, head to to main doors.}')))
      rob_opr_base.adjust_alert_level(name, 7)
      rob_opr_base.trigger_alarm(pos)
      rob_opr_base.win = true
      self.object:remove()
   end,

   on_rightclick = function(self, clicker)
      local pos = self.object:get_pos()
      local name = clicker:get_player_name()
      minetest.chat_send_player(name, (minetest.colorize('#49adff', '{Excellent work agent, now make an escape. I\'m sending a dropship to pick you up, head to to main doors.}')))
      rob_opr_base.adjust_alert_level(name, 7)
      rob_opr_base.trigger_alarm(pos)
      rob_opr_base.win = true
      self.object:remove()
   end,

})
