local door_open = {
   type = 'fixed',
   fixed = {{-.5, -.5, -.375, -.3125, 1.4375, .5}}
}

local door_closed = {
   type = 'fixed',
   fixed = {{-.4375, -.5, -.5, .4375, 1.4375, -.375}}
}

local push_door_inspection = {
   '[Wowzers, \'tis a door.]',
   '[Looks like a normal door.]',
   '[This might be a fire rated door.]',
   '[This is no window.]',
   '[Sounds like a flimsy hollow core door.]',
   '[A door is only as strong as the lock and jam.]',
   '[This door has more coats of paint on it than I do.]'
}

minetest.register_node('rob_opr_base:door_push_open', {
   description = 'Push Open Door (open)',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_door_push_open.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_door_push_open.png'},
   groups = {oddly_breakable_by_hand = 3},
   collision_box = door_open,
   selection_box = door_open,
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      rob_opr_base.act_menu[name] = pos
      minetest.show_formspec(name, 'action_menu', rob_opr_base.action_menu('1011'))
   end,
   _on_use = function(pos, name)
      local node = minetest.get_node(pos)
      minetest.swap_node(pos, {name = 'rob_opr_base:door_push_closed', param2 = node.param2})
      minetest.close_formspec(name, 'action_menu')
      rob_opr_base.adjust_alert_level(name, 1)
   end,
   _on_inspect = function(pos, name)
      minetest.chat_send_player(name, (minetest.colorize('#28b928', rob_opr_base.random_chat(push_door_inspection))))
   end,
   on_punch = function(pos, node, puncher)
      minetest.swap_node(pos, {name = 'rob_opr_base:door_push_closed', param2 = node.param2})
      local name = puncher:get_player_name()
      rob_opr_base.adjust_alert_level(name, 1)
   end,
})

minetest.register_node('rob_opr_base:door_push_closed', {
   description = 'Push Open Door (closed)',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_door_push_closed.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_door_push_closed.png'},
   groups = {oddly_breakable_by_hand = 3},
   collision_box = door_closed,
   selection_box = door_closed,
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      rob_opr_base.act_menu[name] = pos
      minetest.show_formspec(name, 'action_menu', rob_opr_base.action_menu('1011'))
   end,
   _on_use = function(pos, name)
      local node = minetest.get_node(pos)
      minetest.swap_node(pos, {name = 'rob_opr_base:door_push_open', param2 = node.param2})
      minetest.close_formspec(name, 'action_menu')
      rob_opr_base.adjust_alert_level(name, 1)
   end,
   _on_inspect = function(pos, name)
      minetest.chat_send_player(name, (minetest.colorize('#28b928', rob_opr_base.random_chat(push_door_inspection))))
   end,
   on_punch = function(pos, node, puncher)
      local name = puncher:get_player_name()
      minetest.swap_node(pos, {name = 'rob_opr_base:door_push_open', param2 = node.param2})
      rob_opr_base.adjust_alert_level(name, 1)
   end,
})

minetest.register_node('rob_opr_base:door_3x3_open', {
   description = 'Open Door',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_door_3x3_open.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_door_3x3_open.png'},
   groups = {oddly_breakable_by_hand=3, not_in_creative_inventory=1},
   drop = 'rob_opr_base:door_3x3_closed',
   selection_box = {
      type = 'fixed',
         fixed = {
            {-2.5, -.5, -.1, .5, -.4, .1},
            {-2.5, 1, -.1, -2, 2.5, .1},
            {0, 1, -.1, .5, 2.5, .1},},
   },
   collision_box = {
      type = 'fixed',
         fixed = {
            {-2.5, -.5, -.1, .5, -.4, .1},
            {-2.5, 1, -.1, -2, 2.5, .1},
            {0, 1, -.1, .5, 2.5, .1},},
   },
   on_rightclick = function(pos, node)
      minetest.set_node(pos, {name = 'rob_opr_base:door_3x3_closed', param2=node.param2})
      minetest.sound_play('rob_opr_base_door_close', {pos = pos, max_hear_distance = 10, gain = 1})
   end,
   on_timer = function(pos)
      local node = minetest.get_node(pos)
      minetest.set_node(pos, {name = 'rob_opr_base:door_3x3_closed', param2=node.param2})
      minetest.sound_play('rob_opr_base_door_close', {pos = pos, max_hear_distance = 10, gain = .5})
   end
})

minetest.register_node('rob_opr_base:door_3x3_closed', {
   description = 'Closed Door',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_door_3x3_closed.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_door_3x3_closed.png'},
   groups = {oddly_breakable_by_hand=3},
   selection_box = {
      type = 'fixed',
         fixed = {
            {-2.5, -.5, -.1, .5, 2.5, .1}},
   },
   collision_box = {
      type = 'fixed',
         fixed = {
            {-2.5, -.5, -.1, .5, 2.5, .1}},
   },
   on_rightclick = function(pos, node, clicker)
      local timer = minetest.get_node_timer(pos)
      local name = clicker:get_player_name()
      timer:start(5)
      minetest.set_node(pos, {name = 'rob_opr_base:door_3x3_open', param2=node.param2})
      minetest.sound_play('rob_opr_base_door_open', {pos = pos, max_hear_distance = 10, gain = 1})
      if rob_opr_base.win then
         minetest.show_formspec(name, 'end_screen', rob_opr_base.end_game_win)
      else
         minetest.show_formspec(name, 'end_screen', rob_opr_base.end_game_quit)
      end
   end,
})
