function rob_opr_base.fireworks(pos)
   minetest.sound_play('rob_opr_base_air_canon', {pos = pos, gain = 1, max_hear_distance = 16})
   minetest.add_particlespawner({
      amount = 150,
      time = .25,
      glow = 14,
      pos = {min = {x=pos.x-.5, y=pos.y-.5, z=pos.z-.5},
            max = {x=pos.x+.5, y=pos.y-.5, z=pos.z+.5},
            bias = 0},
      minvel = {x=-1, y=3, z=-1},
      maxvel = {x=1, y=8, z=1},
      exptime = {min = 2, max = 3},
      collisiondetection = false,
      collision_removal = false,
      texpool = {
         {name = 'rob_opr_base_firework_red.png',
                  blend = 'alpha',
                  scale_tween = {
                     {x=.5,y=1},
                     {x=1,y=4}
                  }},
         {name = 'rob_opr_base_firework_blue.png',
                  blend = 'alpha',
                  scale_tween = {
                     {x=.5,y=1},
                     {x=1,y=4}
                  }},
         {name = 'rob_opr_base_firework_green.png',
                  blend = 'alpha',
                  scale_tween = {
                     {x=.5,y=1},
                     {x=1,y=4}
                  }},
      }
   })
end

function rob_opr_base.vaporize(pos)
   --minetest.sound_play('rob_opr_base_air_canon', {pos = pos, gain = 1, max_hear_distance = 16})
   minetest.add_particlespawner({
      amount = 150,
      time = .1,
      glow = 10,
      pos = {min = {x=pos.x-.25, y=pos.y, z=pos.z-.25},
            max = {x=pos.x+.25, y=pos.y-.25, z=pos.z+.25},
            bias = 0},
      minvel = {x=-1, y=.1, z=-1},
      maxvel = {x=1, y=2, z=1},
      exptime = {min = 3, max = 4},
      collisiondetection = false,
      collision_removal = false,
      texpool = {
         {name = 'rob_opr_base_flame.png',
                  blend = 'alpha',
                  scale_tween = {
                     {x=3,y=3},
                     {x=6,y=6}
                  }},
         {name = 'rob_opr_base_smoke_1.png',
                  blend = 'alpha',
                  scale_tween = {
                     {x=1,y=1},
                     {x=8,y=8}
                  }},
         {name = 'rob_opr_base_smoke_2.png',
                  blend = 'alpha',
                  scale_tween = {
                     {x=3,y=3},
                     {x=12,y=12}
                  }},
      }
   })
end
