function rob_opr_base.trigger_alarm(pos)
   local pos = pos or {x=0, y=0, z=0}
   local pos1 = vector.add(pos, {x=15, y=2, z=15})
   local pos2 = vector.subtract(pos, {x=15, y=2, z=15})
   local spawns = minetest.find_nodes_in_area(pos1, pos2, 'rob_opr_base:drone_dock')
   for _, pos in ipairs(spawns) do
      minetest.add_entity(pos, 'rob_opr_base:drone_assassin')
   end
end

function rob_opr_base.send_cleaners(pos)
   local pos = pos or {x=0, y=0, z=0}
   local pos1 = vector.add(pos, {x=15, y=1, z=15})
   local pos2 = vector.subtract(pos, {x=15, y=5, z=15})
   local spawns = minetest.find_nodes_in_area(pos1, pos2, 'rob_opr_base:drone_dock')
   for _, pos in ipairs(spawns) do
      minetest.add_entity(pos, 'rob_opr_base:drone_security')
   end
end

local docking_station = {
   type = 'fixed',
   fixed = {{-.1875, -.5, .375, .1875, 0, .5}}
}

minetest.register_node('rob_opr_base:drone_dock', {
   description = 'Drone Dock',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_drone_dock.obj',
   tiles = {'rob_opr_base_drone_dock.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   groups = {oddly_breakable_by_hand = 3},
   collision_box = docking_station,
   selection_box = docking_station,
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      rob_opr_base.act_menu[name] = pos
      minetest.show_formspec(name, 'action_menu', rob_opr_base.action_menu('1110'))
   end,
   _on_report = function(pos, name)
      minetest.chat_send_player(name, (minetest.colorize('#49adff', '{A robot vacuum docking station? Probably not anything to worry about.}')))
      rob_opr_base.adjust_anger(name, 1)
   end,
   _on_inspect = function(pos, name)
      minetest.chat_send_player(name, (minetest.colorize('#28b928', '[Looks to be some sort of docking station.]')))
      rob_opr_base.adjust_alert_level(name, 3)
   end,
   _on_take = function(pos, name, player)
      minetest.chat_send_player(name, (minetest.colorize('#ff0000', '<I don\'t really need this.>')))
   end
})



minetest.register_entity('rob_opr_base:drone_security', {
   initial_properties = {
      visual = 'mesh',
      mesh = 'rob_opr_base_drone_security.obj',
      visual_size = {x=10, y=10},
      physical = true,
      collisionbox = {-.25, -.5, -.25, .25, -.325, .25},
      textures = {'rob_opr_base_drone_security.png'},
      glow = 1,
      automatic_face_movement_dir = 0.0,
   },

   on_activate = function(self, staticdata, dtime_s)
      self.object:set_velocity({x=0, y=0, z=-1})
   end,

   on_step = function(self, dtime, moveresults)
      self.node_timer = (self.node_timer or 0) + dtime
      if self.node_timer > 1 then
         self.node_timer = 0
         local pos = vector.round(self.object:get_pos())
         local below_pos = vector.subtract(pos, {x=0, y=1, z=0})
         local below_node = minetest.get_node(below_pos).name
         if below_node == 'air' then
            local vel = self.object:get_velocity()
            self.object:set_velocity({x=0, y=-9.8, z=0})
         end
      end

      if moveresults.collides then
         local hit_object = moveresults.collisions[1] and moveresults.collisions[1].type == 'object'
         if hit_object then
            local bump = moveresults.collisions[1].object
            local velocity = moveresults.collisions[1].old_velocity
            bump:set_velocity(velocity)
            local yaw = self.object:get_yaw()
            local x_yaw_random = math.random()
            local z_yaw_random = math.random()
            local new_vel = {
                  x = (math.sin(yaw + x_yaw_random) * -1),
                  y = 0,
                  z = (math.cos(yaw + z_yaw_random) * 1)
               }
            self.object:set_velocity(new_vel)
            if minetest.is_player(moveresults.collisions[1].object) then
               local pos = self.object:get_pos()
               rob_opr_base.trigger_alarm(pos)
            end
         end
         local hit_node = moveresults.collisions[1] and moveresults.collisions[1].type == 'node'
         if hit_node then
            local yaw = self.object:get_yaw()
            local x_yaw_random = math.random()
            local z_yaw_random = math.random()
            local new_vel = {
                  x = (math.sin(yaw + x_yaw_random) * -1),
                  y = 0,
                  z = (math.cos(yaw + z_yaw_random) * 1)
               }
            self.object:set_velocity(new_vel)
         end
      end
   end,

   on_punch = function(self, puncher)
      local pos = self.object:get_pos()
      rob_opr_base.trigger_alarm(pos)
      self.object:set_velocity({x=0, y=0, z=1})
   end,
})

minetest.register_entity('rob_opr_base:drone_assassin', {
   initial_properties = {
      visual = 'mesh',
      mesh = 'rob_opr_base_drone_assassin.obj',
      visual_size = {x=10, y=10},
      physical = true,
      collisionbox = {-.25, -.5, -.25, .25, -.325, .25},
      textures = {'rob_opr_base_drone_assassin.png'},
      automatic_face_movement_dir = 0.0,
   },

   on_activate = function(self, staticdata, dtime_s)
      self.object:set_velocity({x=0, y=0, z=-1})
   end,

   on_step = function(self, dtime, moveresults)
      self.node_timer = (self.node_timer or 0) + dtime
      if self.node_timer > 1 then
         self.node_timer = 0
         local pos = self.object:get_pos()
         local clean_pos = vector.round(pos)
         local below_pos = vector.subtract(clean_pos, {x=0, y=1, z=0})
         local below_node = minetest.get_node(below_pos).name
         if below_node == 'air' then
            local vel = self.object:get_velocity()
            self.object:set_velocity({x=0, y=-9.8, z=0})
         end
         local player = minetest.get_player_by_name('singleplayer')
         local player_pos = player:get_pos()
         local distance = vector.distance(pos, player_pos)
         if distance <= 15 then
            local perhaps = vector.direction(pos, player_pos)
            self.object:set_velocity({x = perhaps.x, y = 0, z = perhaps.z})
         else
            local yaw = self.object:get_yaw()
            local x_yaw_random = math.random()
            local z_yaw_random = math.random()
            local new_vel = {
                  x = (math.sin(yaw + x_yaw_random) * -1.5),
                  y = 0,
                  z = (math.cos(yaw + z_yaw_random) * 1.5)
               }
            self.object:set_velocity(new_vel)
         end
      end

      if moveresults.collides then
         local hit_object = moveresults.collisions[1] and moveresults.collisions[1].type == 'object'
         if hit_object then
            local bump = moveresults.collisions[1].object
            local velocity = moveresults.collisions[1].old_velocity
            bump:set_velocity(velocity)
            local yaw = self.object:get_yaw()
            local x_yaw_random = math.random()
            local z_yaw_random = math.random()
            local new_vel = {
                  x = (math.sin(yaw + x_yaw_random) * -1.5),
                  y = 0,
                  z = (math.cos(yaw + z_yaw_random) * 1.5)
               }
            self.object:set_velocity(new_vel)
            if minetest.is_player(moveresults.collisions[1].object) then
               local player = moveresults.collisions[1].object
               local name = player:get_player_name()
               local physics = player:get_physics_override()
               local old_speed = physics.speed
               if old_speed <= .4 then
                  minetest.clear_objects('quick')
                  minetest.show_formspec(name, 'end_screen', rob_opr_base.end_game_lose)
               else
                  player:set_physics_override({speed=old_speed-.2})
                  local hp = player:get_hp()
                  player:set_hp(hp - 3)
                  local pos = self.object:get_pos()
                  rob_opr_base.trigger_alarm(pos)
               end
            end
         end
         local hit_node = moveresults.collisions[1] and moveresults.collisions[1].type == 'node'
         if hit_node then
            local yaw = self.object:get_yaw()
            local x_yaw_random = math.random()
            local z_yaw_random = math.random()
            local new_vel = {
                  x = (math.sin(yaw + x_yaw_random) * -1.5),
                  y = 0,
                  z = (math.cos(yaw + z_yaw_random) * -1.5)
               }
            self.object:set_velocity(new_vel)
         end
      end
   end,

   on_punch = function(self, puncher)
      local pos = self.object:get_pos()
      rob_opr_base.trigger_alarm(pos)
      self.object:set_velocity({x=0, y=0, z=1.5})
   end,
})
