local function vent_configure(pos)
   local meta = minetest.get_meta(pos)
   local teleport_pos = meta:get_string('teleport_pos') or ''
   local formspec =
      'formspec_version[6]'..
      'size[20,6]'..
      'position[.5,.8]'..
      'no_prepend[]'..
      'bgcolor[#00000000;false]'..
      'background[0,;20,6;rob_opr_base_computer_gui.png]'..
      'textarea[.5,.5;19,2;;;Where should the player be teleported too?]'..
      'field[.5,4.5;4,1;teleport_pos;Start Position;'..teleport_pos..']'..
      'button_exit[6.5,4.5;2,1;save;Save]'..
      'button_exit[17.5,4.5;2,1;;Discard]'
   return formspec
end

minetest.register_node('rob_opr_base:duct_vent', {
   description = 'Ducting Vent',
   light_source = 3,
   tiles = {'rob_opr_base_duct_vent.png'},
   groups = {oddly_breakable_by_hand = 3, configure = 1},
   on_construct = function(pos)
      local default_pos = minetest.pos_to_string(vector.subtract(pos, {x=0, y=3, z=0}))
      local meta = minetest.get_meta(pos)
      meta:set_string('teleport_pos', default_pos)
   end,
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      rob_opr_base.act_menu[name] = pos
      minetest.show_formspec(name, 'action_menu', rob_opr_base.action_menu('1111'))
   end,
   _on_use = function(pos, name)
      minetest.close_formspec(name, 'action_menu')
      local meta = minetest.get_meta(pos)
      local teleport_pos = meta:get_string('teleport_pos')
      local player = minetest.get_player_by_name(name)
      player:set_properties({
         eye_height = 1.47,
         collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
      })
      player:set_physics_override({speed=1})
      player:set_pos(minetest.string_to_pos(teleport_pos))
      rob_opr_base.send_cleaners(pos)
   end,
   on_punch = function(pos, node, puncher)
      local name = puncher:get_player_name()
      minetest.close_formspec(name, 'action_menu')
      local meta = minetest.get_meta(pos)
      local teleport_pos = meta:get_string('teleport_pos')
      puncher:set_properties({
         eye_height = 1.47,
         collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
      })
      puncher:set_physics_override({speed=1})
      puncher:set_pos(minetest.string_to_pos(teleport_pos))
      rob_opr_base.send_cleaners(pos)
   end,
   _on_inspect = function(pos, name)
      minetest.chat_send_player(name, (minetest.colorize('#28b928', '[The venting is filled with dust mites, but looks clean otherwise]')))
   end,
   _on_report = function(pos, name)
      minetest.chat_send_player(name, (minetest.colorize('#49adff', '{That should be your entrance. It might be a bit of a drop, be careful.}')))
      rob_opr_base.adjust_anger(name, -20)
   end,
   _on_take = function(pos, name, player)
      minetest.chat_send_player(name, (minetest.colorize('#ff0000',  '<The vent is too large to put in your backpack.>')))
   end,
   _on_configure = function(pos, name)
      minetest.show_formspec(name, 'vent_configure', vent_configure(pos))
   end
})

minetest.register_on_player_receive_fields(function(player, formname, fields)
   if formname == 'vent_configure' then
      local name = player:get_player_name()
      if fields.save then
         local pos = rob_opr_base.config[name]
         local meta = minetest.get_meta(pos)
         meta:set_string('teleport_pos', fields.teleport_pos)
      end
   end
end)
