minetest.register_node('sss_map:wall_straight_1', {
   description = 'Straight Wall',
   drawtype = 'mesh',
   mesh = 'sss_map_wall_straight_1.obj',
   tiles = {'sss_map_wall_panel_1.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   wield_scale = {x = .5, y = .5, z = .5},
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.25, .5, 1.5, .25},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.25, .5, 1.5, .25},
      },
   groups = {breakable=1},
})

minetest.register_node('sss_map:wall_straight_2', {
   description = 'Straight Wall',
   drawtype = 'mesh',
   mesh = 'sss_map_wall_straight_2.obj',
   tiles = {'sss_map_wall_panel_2.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   wield_scale = {x = .5, y = .5, z = .5},
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.25, 1.5, 1.5, .25},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.25, 1.5, 1.5, .25},
      },
   groups = {breakable=1}
})

minetest.register_node('sss_map:wall_straight_window_1', {
   description = 'Straight Wall with Window',
   drawtype = 'mesh',
   mesh = 'sss_map_wall_straight_1_window.obj',
   tiles = {'sss_map_wall_straight_1_window.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   wield_scale = {x = .5, y = .5, z = .5},
   sunlight_propagates = false,
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.25, .5, 1.5, .25},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.25, .5, 1.5, .25},
      },
   groups = {breakable=1},
})

minetest.register_node('sss_map:wall_straight_window_2', {
   description = 'Straight Wall with Window',
   drawtype = 'mesh',
   mesh = 'sss_map_wall_straight_2_window.obj',
   tiles = {'sss_map_wall_straight_2_window.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   wield_scale = {x = .5, y = .5, z = .5},
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.25, 1.5, 1.5, .25},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.25, 1.5, 1.5, .25},
      },
   groups = {breakable=1}
})

minetest.register_node('sss_map:wall_corner', {
   description = 'Corner Wall',
   drawtype = 'mesh',
   mesh = 'sss_map_wall_corner.obj',
   tiles = {'sss_map_wall_corner.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   wield_scale = {x = .5, y = .5, z = .5},
   selection_box = {
      type = 'fixed',
      fixed = {{-.5, -.5, -.25, .25, 1.5, .25},
               {-.25, -.5, -.5, .25, 1.5, .25}
      }},
   collision_box = {
      type = 'fixed',
      fixed = {{-.5, -.5, -.25, .25, 1.5, .25},
               {-.25, -.5, -.5, .25, 1.5, .25}
      }},
   groups = {breakable=1}
})

minetest.register_node('sss_map:wall_t', {
   description = 'T Wall',
   drawtype = 'mesh',
   mesh = 'sss_map_wall_t.obj',
   tiles = {'sss_map_wall_t.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   wield_scale = {x = .5, y = .5, z = .5},
   selection_box = {
      type = 'fixed',
      fixed = {{-.5, -.5, -.25, .5, 1.5, .25},
               {-.25, -.5, -.5, .25, 1.5, 0}
      }},
   collision_box = {
      type = 'fixed',
      fixed = {{-.5, -.5, -.25, .5, 1.5, .25},
               {-.25, -.5, -.5, .25, 1.5, 0}
      }},
   groups = {breakable=1}
})

minetest.register_node('sss_map:wall_x', {
   description = 'Cross Wall',
   drawtype = 'mesh',
   mesh = 'sss_map_wall_x.obj',
   tiles = {'sss_map_wall_x.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   wield_scale = {x = .5, y = .5, z = .5},
   selection_box = {
      type = 'fixed',
      fixed = {{-.5, -.5, -.25, .5, 1.5, .25},
               {-.25, -.5, -.5, .25, 1.5, .5}
      }},
   collision_box = {
      type = 'fixed',
      fixed = {{-.5, -.5, -.25, .5, 1.5, .25},
               {-.25, -.5, -.5, .25, 1.5, .5}
      }},
   groups = {breakable=1}
})
