local bg =
   'formspec_version[3]'..
   'size[14,8]'..
   'bgcolor[;neither]'..
   'background[-1,-1;16,10;sss_core_bridge_computer_bg.png]'

function sss_core.bridge_computer(pos)
   local formspec =
      bg..
      'style_type[image_button;border=false;bgimg=blank.png]'..
      'image_button[.5,.5;2,2;sss_core_terminal_ico.png;terminal;]'..
      'image_button[3,.5;2,2;sss_core_space_map_ico.png;space_map;]'..
      'image_button[5.5,.5;2,2;sss_core_radio_ico.png;radio;]'
   return formspec
end

local bridge_terminal =
   bg..
   'textarea[.5,1;17,10;;;Here are your notifications.\n]'

minetest.register_on_player_receive_fields(function(player, formname, fields)
   local name = player:get_player_name()
   if formname == 'sss_core:bridge_computer' then
      if fields.terminal then
         minetest.show_formspec(name, 'sss_core:bridge_computer', bridge_terminal)
      elseif fields.space_map then
         minetest.show_formspec(name, 'sss_core:bridge_computer', bridge_space_map)
      elseif fields.radio then
         minetest.show_formspec(name, 'sss_core:bridge_computer', bridge_radio)
      end
   end
end)
