local function config_door_form(infotext_top, infotext_bot, power_level, security_level, save)
   local formspec =
      'formspec_version[3]'..
      'size[12,9]'..
      'textarea[1,1;10,4;;;Set the required power level, security level, and an optional infotext]'..
      'field[1,4.5;4,.6;infotext_top;Outside (top) Infotext;'..infotext_top..']'..
      'field[1,5.5;4,.6;infotext_bot;Inside (bot) Infotext;'..infotext_bot..']'..
      'field[1,6.5;4,.6;power_level;Power Level;'..power_level..']'..
      'field[1,7.5;4,.6;security_level;Security Level;'..security_level..']'..
      'button_exit[8,7;3,1;'..save..';Submit]'
   return formspec
end

local function config_door_bot(name, pos)
   local meta = minetest.get_meta(pos)
   local infotext_bot = meta:get_string('infotext') or ''
   local power_level = meta:get_int('power_level') or 0
   local security_level = meta:get_int('security_level') or 0
   local pos2 = {x=pos.x, y=pos.y+1, z=pos.z}
   local meta = minetest.get_meta(pos2)
   local infotext_top = meta:get_string('infotext') or ''
   minetest.show_formspec(name, 'sss_core:config_door', config_door_form(infotext_top, infotext_bot, power_level, security_level, 'save_bot'))
end

local function config_door_top(name, pos)
   local meta = minetest.get_meta(pos)
   local infotext_top = meta:get_string('infotext') or ''
   local pos2 = {x=pos.x, y=pos.y-1, z=pos.z}
   local meta = minetest.get_meta(pos2)
   local power_level = meta:get_int('power_level') or 0
   local security_level = meta:get_int('security_level') or 0
   local infotext_bot = meta:get_string('infotext') or ''
   minetest.show_formspec(name, 'sss_core:config_door', config_door_form(infotext_top, infotext_bot, power_level, security_level, 'save_top'))
end

minetest.register_tool('sss_core:config_tool', {
   description = 'Configuration Tool',
   inventory_image = 'sss_core_config_tool.png',
   on_use = function(itemstack, user, pointed_thing)
      local pos = minetest.get_pointed_thing_position(pointed_thing)
      if pos then
         local name = user:get_player_name()
         local node = minetest.get_node(pos)
         if not minetest.is_protected(pos, name) or minetest.check_player_privs(name, {server = true}) then
            sss_core.player_config[name] = pos
            if minetest.get_item_group(node.name, 'door') == 1 then
               config_door_bot(name, pos)
            elseif minetest.get_item_group(node.name, 'door') == 2 then
               config_door_top(name, pos)
            else
               minetest.chat_send_player(name, 'Sorry, that item can not be configured.')
            end
         end
      end
   end,
})

minetest.register_on_player_receive_fields(function(player, formname, fields)
   local name = player:get_player_name()
   if formname == 'sss_core:config_door' then
      if fields.save_bot then
         if sss_core.is_integer(fields.power_level) and sss_core.is_integer(fields.security_level) then
            local pos = sss_core.player_config[name]
            local meta = minetest.get_meta(pos)
            meta:set_string('infotext', fields.infotext_bot)
            meta:set_int('power_level', fields.power_level)
            meta:set_int('security_level', fields.security_level)
            local pos2 = {x=pos.x, y=pos.y+1, z=pos.z}
            local meta = minetest.get_meta(pos2)
            meta:set_string('infotext', fields.infotext_top)
         else
            minetest.chat_send_player(name, 'Please check your inputs.')
         end
      elseif fields.save_top then
         if sss_core.is_integer(fields.power_level) and sss_core.is_integer(fields.security_level) then
            local pos = sss_core.player_config[name]
            local meta = minetest.get_meta(pos)
            meta:set_string('infotext', fields.infotext_top)
            print (fields.infotext_top)
            local pos2 = {x=pos.x, y=pos.y-1, z=pos.z}
            local meta = minetest.get_meta(pos2)
            meta:set_string('infotext', fields.infotext_bot)
            meta:set_int('power_level', fields.power_level)
            meta:set_int('security_level', fields.security_level)
         else
            minetest.chat_send_player(name, 'Please check your inputs.')
         end
      end
   end
end)
