function sss_core.is_integer(input)
   local number = tonumber(input)
   if number then
      if math.floor(number) == number then
         return true
      end
   end
end

function sss_core.load()
   local file = io.open(minetest.get_worldpath() .. '/data', 'r')
   if file then
      sss_core.savedata = minetest.deserialize(file:read('*a'))
      file:close()
   else
      sss_core.savedata.power_level = 0
      sss_core.savedata.power_to_fail = 'false'
   end
   local failure = sss_core.savedata.power_to_fail
   if failure == 'true' then
      minetest.after(5, function()
         minetest.sound_play('power_critical')
         minetest.chat_send_all('Power systems critical')
      end)
      minetest.after(180, function()
         sss_core.savedata.power_level = 1
         sss_core.savedata.power_to_fail = 'false'
         minetest.sound_play('power_off')
         minetest.chat_send_all('Power Failure!')
         sss_core.savedata.notifications = 'Power Transformers offline!'
      end)
   end
end

function sss_core.save()
   local file = io.open(minetest.get_worldpath() .. '/data', 'w')
   file:write(minetest.serialize(sss_core.savedata))
   file:close()
end

local function select_name(table)
   local max = #(table)
   local key = math.random(1,max)
   local name = table[key]
   return name
end

local male_names = {
   'David Ryman',
   'Joshua Beasley',
   'Jason Spencer',
   'Tobby Buhs',
   'Steven Lehman',
   'Michael Cantwell',
   'Ed Hassell',
   'Jonathan Newton',
   'Trey Kurtz',
   'Matthew Chew',
   'Matthew Cox',
   'Donald Farrell',
   'Gregory Biggs',
   'Edward McMichael',
   'Roger Marmet',
   'Preston Coffey',
   'Jacob Thomas',
   'Douglas London'
}

local female_names = {
   'Lori Milks',
   'Emily Murray',
   'Tina Tintor',
   'Tanya Chamberlain',
   'Tracy Algar',
   'Doris Huffhines',
   'Susan Jordan',
   'Kelli O\'Laughlin',
   'Judy Jester',
   'Allison Griffor',
   'Deborah London',
   'Cheryl Livy',
   'Colleen Ritzer',
   'Cary Robuck',
   'Maelyn Lind'
}

function sss_core.gen_crew_data(pos)
   local meta = minetest.get_meta(pos)
   local name = meta:get_string('name')
   if name == '' then
      local photo
      local age = math.random(20, 40)
      local sex
      local rank
      if math.random(1,2) == 1 then
         sex = 'Male'
         photo = 'm'..math.random(1,15)
         name = select_name(male_names)
      else
         sex = 'Female'
         photo = 'f'..math.random(1,12)
         name = select_name(female_names)
      end
      if math.random(1,4) == 1 then
         rank = 'Civilian'
      else
         rank = 'Cadet'
      end
      meta:set_string('photo', photo)
      meta:set_string('name', name)
      meta:set_string('age', age)
      meta:set_string('sex', sex)
      meta:set_string('rank', rank)
   end
end
