minetest.register_node('sss_map:terminal_wall', {
   description = 'Wall Mounted Terminal',
   drawtype = 'mesh',
   mesh = 'sss_map_terminal_wall.obj',
   tiles = {'sss_map_terminal_wall.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   light_source = 2,
   selection_box = {
      type = 'fixed',
      fixed = {-.375, -.4375, .5625, .375, .06125, .75},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.375, -.4375, .5625, .375, .06125, .75},
      },
   groups = {breakable=1},
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      minetest.show_formspec(name, 'sss_core:terminal', sss_core.terminal_welcome())
   end,
})

minetest.register_node('sss_map:terminal_wall_1', {
   description = 'Node Mounted Terminal',
   drawtype = 'mesh',
   mesh = 'sss_map_terminal_wall_1.obj',
   tiles = {'sss_map_terminal_wall.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   light_source = 2,
   selection_box = {
      type = 'fixed',
      fixed = {-.375, -.4375, .3125, .375, .06125, .5},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.375, -.4375, .3125, .375, .06125, .5},
      },
   groups = {breakable=1},
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      minetest.show_formspec(name, 'sss_core:terminal', sss_core.terminal_welcome())
   end,
})
