local drop_list_1 = { --these drop when a civilian clicks
   'sss_items:rations_1',
   'sss_items:rations_1',
   'sss_items:rations_2',
   'sss_items:handbook_orange',
   'sss_items:handbook_blue_2',
   'sss_items:handbook_purple',
   'sss_items:handbook_green_1',
   'sss_items:handbook_cadet',
}

local drop_list_2 = { -- these drop when a cadet clicks
   'sss_items:rations_1',
   'sss_items:rations_2',
   'sss_items:rations_2',
   'sss_items:handbook_blue',
   'sss_items:handbook_blue_1',
   'sss_items:handbook_mechanic',
}

local drop_list_3 = { --these drop when mechanic clicks
   'sss_items:rations_2',
   'sss_items:rations_2',
   'sss_items:rations_3',
   'sss_items:handbook_green_2',
   'sss_items:handbook_1',
}

local drop_list_4 = {-- these drop when an engineer clicks
   'sss_items:rations_2',
   'sss_items:rations_3',
   'sss_items:rations_3',
   'sss_items:handbook_red',
   'sss_items:handbook_green',
   'sss_items:handbook_2',
}

local drop_list_5 = { -- these drop when a third officer clicks
   'sss_items:rations_3',
   'sss_items:rations_3',
   'sss_items:rations_3',
   'sss_items:handbook_3',
   'sss_items:handbook_4',
}

local drop_list_6 = { -- these drop when a second officer or higher clicks
   'sss_items:rations_3',
   'sss_items:rations_3',
   'sss_items:rations_3',
   'sss_items:handbook_5',
   'sss_items:handbook_6',
}

local function select_item(tier)
   local name = ''
   if tier == 1 then
      local max = #(drop_list_1)
      local key = math.random(1,max)
      name = drop_list_1[key]
   elseif tier == 2 then
      local max = #(drop_list_2)
      local key = math.random(1,max)
      name = drop_list_2[key]
   elseif tier == 3 then
      local max = #(drop_list_3)
      local key = math.random(1,max)
      name = drop_list_3[key]
   elseif tier == 4 then
      local max = #(drop_list_4)
      local key = math.random(1,max)
      name = drop_list_4[key]
   elseif tier == 5 then
      local max = #(drop_list_5)
      local key = math.random(1,max)
      name = drop_list_5[key]
   elseif tier >= 6 then
      local max = #(drop_list_6)
      local key = math.random(1,max)
      name = drop_list_6[key]
   end
   return name
end

local function is_first_free_slot(player, index)
   local player_inv = player:get_inventory()
   local first_free = index+1
   for i = 1, index, 1 do
      local curstk = player_inv:get_stack('main', i)
      if curstk:is_empty() and i < first_free then
         first_free = i
         break
      end
   end
   return (first_free == index)
end

local function dispense(pos, node, clicker, wielded)
   local meta = minetest.get_meta(pos)
   local has_item = meta:get_string('item')
   if has_item == '' then
      local player_meta = clicker:get_meta()
      local security_level = player_meta:get_int('security_level') or 0
      local tier = security_level + 1
      local pos1 = {x=pos.x-6, y=pos.y, z=pos.z-6}
      local pos2 = {x=pos.x+6, y=pos.y, z=pos.z+6}
      local nodes = minetest.find_nodes_in_area(pos1, pos2, {'group:dispenses'})
      local payload = math.random(#nodes)
      for i = 1, #nodes do
         local chosen_pos = nodes[i]
         local meta = minetest.get_meta(chosen_pos)
         local item = meta:get_string('item')
         if item == '' then
            meta:set_string('item', select_item(tier))
            if i == payload then
               meta:set_string('item', 'sss_items:id_'..tier)
            end
         end
      end
   elseif has_item == 'none' then
       --do nothing
   else
      local player_inv = clicker:get_inventory()
      if player_inv:room_for_item('main', has_item) then
         if not player_inv:contains_item('main', has_item) then
            local wield_slot = is_first_free_slot(clicker, clicker:get_wield_index())
            player_inv:add_item('main', has_item)
            local inv_name = ItemStack(has_item)
            meta:set_string('item', 'none')
            if wielded:is_empty() and wield_slot then
               return ItemStack(has_item)
            end
         end
      else
         minetest.chat_send_player(clicker:get_player_name(), 'You find a something, but have no space to store it.')
      end
   end
end

minetest.register_node('sss_map:bed', {
   description = 'Bed with white Blankets',
   drawtype = 'mesh',
   mesh = 'sss_map_bed.obj',
   tiles = {'sss_map_bed.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {{-.5, -.5, -.5, .5, 0, 1.5},
              {-.5, 0, 1.35, .5, .5, 1.5}}
   },
   collision_box = {
      type = 'fixed',
      fixed = {{-.5, -.5, -.5, .5, 0, 1.5},
                 {-.5, 0, 1.35, .5, .5, 1.5}}
   },
   groups = {breakable=1, dispenses=1},
   on_rightclick = dispense
})

minetest.register_node('sss_map:nightstand', {
   description = 'Nightstand',
   drawtype = 'mesh',
   mesh = 'sss_map_nightstand.obj',
   tiles = {'sss_map_nightstand.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.25, .5, .5, .5},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.25, .5, .5, .5},
      },
   groups = {breakable=1, dispenses=1},
   on_rightclick = dispense
})

minetest.register_node('sss_map:dresser_wide', {
   description = 'Wide Dresser',
   drawtype = 'mesh',
   mesh = 'sss_map_dresser_wide.obj',
   tiles = {'sss_map_dresser_wide.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.375, 1.5, .5, .5},
   },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.375, 1.5, .5, .5},
   },
   groups = {breakable=1, dispenses=1},
   on_rightclick = dispense
})

minetest.register_node('sss_map:dresser_tall', {
   description = 'Tall Dresser',
   drawtype = 'mesh',
   mesh = 'sss_map_dresser_tall.obj',
   tiles = {'sss_map_dresser_tall.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.375, .5, 1.5, .5},
   },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.375, .5, 1.5, .5},
   },
   groups = {breakable=1, dispenses=1},
   on_rightclick = dispense
})

minetest.register_node('sss_map:desk', {
   description = 'Desk',
   drawtype = 'mesh',
   mesh = 'sss_map_desk.obj',
   tiles = {'sss_map_desk.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, 1.5, .5, .5}
   },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, 1.5, .5, .5}
   },
   groups = {breakable=1, dispenses=1},
   on_rightclick = dispense
})

minetest.register_node('sss_map:cabinet_counter', {
   description = 'Cabinet with Countertop',
   drawtype = 'mesh',
   mesh = 'sss_map_cabinet_counter.obj',
   tiles = {'sss_map_cabinet_counter.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, .5, .5, .5},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, .5, .5, .5},
      },
   groups = {breakable=1, dispenses=1},
   on_rightclick = dispense
})

minetest.register_node('sss_map:cabinet_counter_sink', {
   description = 'Cabinet with Sink',
   drawtype = 'mesh',
   mesh = 'sss_map_cabinet_sink.obj',
   tiles = {'sss_map_cabinet_counter.png', 'sss_map_cabinet_sink.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, .5, .5, .5},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, .5, .5, .5},
      },
   groups = {breakable=1, dispenses=1},
   on_rightclick = dispense
})

minetest.register_node('sss_map:cabinet_counter_corner_inside', {
   description = 'Cabinet with Countertop (Inside Corner)',
   drawtype = 'mesh',
   mesh = 'sss_map_cabinet_counter_ci.obj',
   tiles = {'sss_map_cabinet_counter_ci.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, .5, .5, .5},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, .5, .5, .5},
      },
   groups = {breakable=1, dispenses=1},
   on_rightclick = dispense
})

minetest.register_node('sss_map:cabinet_counter_corner_outside', {
   description = 'Cabinet with Countertop (Outside Corner)',
   drawtype = 'mesh',
   mesh = 'sss_map_cabinet_counter_co.obj',
   tiles = {'sss_map_cabinet_counter_co.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, .5, .5, .5},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, .5, .5, .5},
      },
   groups = {breakable=1, dispenses=1},
   on_rightclick = dispense
})

minetest.register_node('sss_map:oven', {
   description = 'Oven',
   drawtype = 'mesh',
   mesh = 'sss_map_oven.obj',
   tiles = {'sss_map_oven.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   groups = {breakable=1, dispenses=1},
   on_rightclick = dispense
})

minetest.register_node('sss_map:refrigerator_industrial', {
   description = 'Industrial Refrigerator',
   drawtype = 'mesh',
   mesh = 'sss_map_refrigerator_industrial.obj',
   tiles = {'sss_map_refrigerator_industrial.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.375, .5, 1.5, .5},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.375, .5, 1.5, .5},
      },
   groups = {breakable=1, dispenses=1},
   on_rightclick = dispense
})

minetest.register_node('sss_map:refrigerator', {
   description = 'Refrigerator',
   drawtype = 'mesh',
   mesh = 'sss_map_refrigerator.obj',
   tiles = {'sss_map_refrigerator.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.375, .5, 1.5, .5},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.375, .5, 1.5, .5},
      },
   groups = {breakable=1, dispenses=1},
   on_rightclick = dispense
})

minetest.register_node('sss_map:file_cabinet', {
   description = 'File Cabinet',
   drawtype = 'mesh',
   mesh = 'sss_map_file_cabinet.obj',
   tiles = {'sss_map_file_cabinet.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.45, -.5, -.5, .45, 1, .45},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.45, -.5, -.5, .45, 1, .45},
      },
   groups = {breakable=1, dispenses=1},
   on_rightclick = dispense
})

minetest.register_node('sss_map:chest', {
   description = 'Large Chest',
   drawtype = 'mesh',
   mesh = 'sss_map_chest.obj',
   tiles = {'sss_map_chest.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.4, 1.5, .3, .5},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.4, 1.5, .3, .5},
      },
   groups = {breakable=1, dispenses=1},
   on_rightclick = dispense
})
