local function rightclick(pos, node, clicker)
   local name = clicker:get_player_name()
   local power_level = sss_core.savedata.power_level
   if power_level < 3 then
      minetest.chat_send_player(name, 'Computer doesn\'t boot.')
   else
      minetest.set_node(pos, {name = node.name..'_on', param2 = node.param2})
      minetest.after(2, function()
         minetest.show_formspec(name, 'sss_core:bridge_computer', sss_core.bridge_computer(pos))
      end)
   end
end

local function rightclick_on(pos, node, clicker)
   local name = clicker:get_player_name()
   local node_name = node.name
   local node_name = string.sub(node_name, 1, -4)
   local power_level = sss_core.savedata.power_level
   if power_level < 3 then
      minetest.chat_send_player(name, 'Computer crashes!')
      minetest.set_node(pos, {name = node_name, param2 = node.param2})
   else
      minetest.show_formspec(name, 'sss_core:bridge_computer', sss_core.bridge_computer(pos))
   end
end

minetest.register_node('sss_map:desk_1', {
   description = 'Desk',
   drawtype = 'mesh',
   mesh = 'sss_map_desk_1.obj',
   tiles = {'sss_map_desk_1.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {{-.5, -.5, -.5, 1.5, .5, .5},
               {-.4357, .5, -.3125, 1.4375, 1, .4375}
      }},
   collision_box = {
      type = 'fixed',
      fixed = {{-.5, -.5, -.5, 1.5, .5, .5},
               {-.4357, .5, -.3125, 1.4375, 1, .4375}
      }},
   groups = {breakable=1, bridge=1},
   on_rightclick = rightclick
})

minetest.register_node('sss_map:desk_1_on', {
   description = 'Desk',
   drawtype = 'mesh',
   mesh = 'sss_map_desk_1.obj',
   tiles = {'sss_map_desk_1_on.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {{-.5, -.5, -.5, 1.5, .5, .5},
               {-.4357, .5, -.3125, 1.4375, 1, .4375}
      }},
   collision_box = {
      type = 'fixed',
      fixed = {{-.5, -.5, -.5, 1.5, .5, .5},
               {-.4357, .5, -.3125, 1.4375, 1, .4375}
      }},
   groups = {breakable=1, bridge=1},
   on_rightclick = rightclick_on
})

minetest.register_node('sss_map:desk_2', {
   description = 'Desk',
   drawtype = 'mesh',
   mesh = 'sss_map_desk_2.obj',
   tiles = {'sss_map_desk_2.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {{-1.5, -.5, -.5, 1.5, .5, .5},
               {.5, .5, -.25, 1.4375, 1.25, .3125},
               {-.5, .5, -.25, -1.4375, 1.25, .3125}
      }},
   collision_box = {
      type = 'fixed',
      fixed = {{-1.5, -.5, -.5, 1.5, .5, .5},
               {-.4357, .5, -.3125, 1.4375, 1, .4375}
      }},
   groups = {breakable=1, bridge=1},
   on_rightclick = rightclick
})

minetest.register_node('sss_map:desk_2_on', {
   description = 'Desk',
   drawtype = 'mesh',
   mesh = 'sss_map_desk_2.obj',
   tiles = {'sss_map_desk_2_on.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {{-1.5, -.5, -.5, 1.5, .5, .5},
               {.5, .5, -.25, 1.4375, 1.25, .3125},
               {-.5, .5, -.25, -1.4375, 1.25, .3125}
      }},
   collision_box = {
      type = 'fixed',
      fixed = {{-1.5, -.5, -.5, 1.5, .5, .5},
               {-.4357, .5, -.3125, 1.4375, 1, .4375}
      }},
   groups = {breakable=1, bridge=1},
   on_rightclick = rightclick_on
})
