minetest.register_node('sss_map:engine_storage_tank', {
   description = 'Fuel Storage Tank',
   drawtype = 'mesh',
   mesh = 'sss_map_engine_tank.obj',
   tiles = {'sss_map_engine_tank.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.4, 1.5, .375, .5},
   },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.4, 1.5, .3, .5},
   },
   groups = {breakable=1}
})

minetest.register_node('sss_map:engine', {
   description = 'Engine',
   drawtype = 'mesh',
   mesh = 'sss_map_engine.obj',
   tiles = {'sss_map_engine.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.4, 1.5, .5, .5},
   },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.4, 1.5, .3, .5},
   },
   groups = {breakable=1}
})

minetest.register_node('sss_map:power_substation', {
   description = 'Power Substation',
   drawtype = 'mesh',
   mesh = 'sss_map_power_substation.obj',
   tiles = {'sss_map_power_substation.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-1, -1, .25, .75, .5, .5},
   },
   collision_box = {
      type = 'fixed',
      fixed = {-1, -1, .25, .75, .5, .5},
   },
   groups = {breakable=1},
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      sss_core.player_config[name] = pos
      minetest.show_formspec(name, 'sss_core:power_substation', sss_core.power_substation(pos))
   end,
})

local transformer_parts = {
   'sss_items:coil_core',
   'sss_items:difference_filter',
   'sss_items:fuel_filter',
   'sss_items:plasma_chamber',
   'sss_items:reduction_chamber'
}

local function select_item()
   local max = #(transformer_parts)
   local key = math.random(1,max)
   local name = transformer_parts[key]
   return name
end

local function power_transformer_formspec(pos)
   local spos = pos.x ..','.. pos.y ..','.. pos.z
   local formspec =
      'formspec_version[3]'..
      'size[5,10]'..
      'bgcolor[;neither]'..
      'background[-1,-1;7,12;sss_core_power_transformer_bg.png]'..
      'list[nodemeta:'..spos..';part;3.75,.25;1,1;]'..
      'list[current_player;main;.125,7.6;4,2;]'
   return formspec
end

minetest.register_node('sss_map:power_transformer', {
   description = 'Power Transformer',
   drawtype = 'mesh',
   mesh = 'sss_map_power_transformer.obj',
   tiles = {'sss_map_power_transformer.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, .5, 1.5, .5},
   },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, .5, 1.5, .5},
   },
   groups = {breakable=1},
   on_construct = function(pos)
      local meta = minetest.get_meta(pos)
      local inv = meta:get_inventory()
      meta:set_string('part', select_item())
      inv:set_size('part', 1)
   end,
   allow_metadata_inventory_put = function(pos, listname, index, stack, player)
      if minetest.get_item_group(stack:get_name(), 'power_trans_part') == 1 then
         return 1
      else
         return 0
      end
   end,
   on_metadata_inventory_put = function(pos, listname, index, stack, player)
      local name = player:get_player_name()
      local meta = minetest.get_meta(pos)
      local inv = meta:get_inventory()
      local part = meta:get_string('part')
      local item = stack:get_name()
      if item ~= part then
         minetest.chat_send_player(name, 'That didn\'t fix things, but it never hurts to replace old parts.')
      elseif item == part then
         minetest.chat_send_player(name, 'This transformer seems to be working properly.')
         meta:set_string('part', 'fixed')
         local pos1 = {x=pos.x-20, y=pos.y-1, z=pos.z-20}
         local pos2 = {x=pos.x+20, y=pos.y+1, z=pos.z+20}
         local nodes = minetest.find_nodes_in_area(pos1, pos2, {'sss_map:power_transformer'})
         local total = 0
         for i = 1, #nodes do
            local chosen_pos = nodes[i]
            local meta = minetest.get_meta(chosen_pos)
            local item = meta:get_string('part')
            if item == 'fixed' then
               total = total + 1
            end
         end
         if total == 6 then
            minetest.chat_send_player(name, 'Transformers are all fixed, power should come back online any second.')
            minetest.sound_play('power_on', {to_player = name})
            sss_core.savedata.power_level = 3
         end
      end
      inv:set_stack(listname, index, nil)
      minetest.close_formspec(name, 'sss_core:power_transformer')
   end,
   on_rightclick = function(pos, node, clicker)
      local meta = minetest.get_meta(pos)
      local part = meta:get_string('part')
      local power_level = sss_core.savedata.power_level
      if power_level == 1 and part ~= 'fixed' then
         local name = clicker:get_player_name()
         minetest.show_formspec(name, 'sss_core:power_transformer', power_transformer_formspec(pos))
      end
   end,
})
