local modstorage = minetest.get_mod_storage()
local first = modstorage:get_string('first_join')

local welcome_screen =
   'formspec_version[3]'..
   'size[20,10]'..
   'bgcolor[;true;black]'..
   'background[-3,-3;26,16;sss_core_outterspace.png]'..
   'image[4.5,0;11,10;sss_core_spaceship.png]'..
   'style_type[textarea;border=true;font_size=30;textcolor=red]'..
   'textarea[4,3;12,4;;;You find yourself stranded in a seemingly deserted spaceship. Where did the crew go, why is the ship empty, or is it? Only one way to find out.]'..
   'style_type[image_button;border=false;bgimg=blank.png]'..
   'image_button[8,6;4,2;sss_core_start_game.png;start_game;]'

minetest.register_on_joinplayer(function(player)
   if first ~= 'false' then
      local name = player:get_player_name()
      minetest.show_formspec(name, 'sss_core:welcome', welcome_screen)
      player:set_physics_override({speed=0, gravity=0})
      player:set_properties{eye_height = 1.5}
      player:set_pos({x=110,y=12,z=46})
   else
      player:set_properties{eye_height = 1.5}
      player:set_physics_override({speed=1, gravity=.8})
   end
end)

minetest.register_on_player_receive_fields(function(player, formname, fields)
   local name = player:get_player_name()
   if formname == 'sss_core:welcome' then
      if fields.start_game then
         player:set_pos({x=110,y=12,z=46})
         player:set_physics_override({speed=1, gravity=.8})
         minetest.close_formspec(name, 'sss_core:welcome')
         modstorage:set_string('first_join', 'false')
      end
   end
end)
