local function door_opening(pos, node, clicker, swap_to_name, swap_from)
   local name = clicker:get_player_name()
   local meta = minetest.get_meta(pos)
   local power_level = meta:get_int('power_level') or 0
   local security_level = meta:get_int('security_level') or 0
   if sss_core.savedata.power_level >= power_level then
      local player_meta = clicker:get_meta()
      local player_security_level = player_meta:get_int('security_level') or 0
      if player_security_level >= security_level then
         minetest.swap_node(pos, {name = swap_to_name, param2 = node.param2})
         minetest.after(3, function()
            minetest.swap_node(pos, {name = swap_from, param2 = node.param2})
         end)
      else
         minetest.chat_send_player(name, 'You need higher security clearance.')
      end
   else
      minetest.chat_send_player(name, 'Not enough power to operate this door.')
   end
end

minetest.register_node('sss_map:door_1', {
   description = 'Door (1 wide)',
   drawtype = 'mesh',
   mesh = 'sss_map_door_1.obj',
   tiles = {'sss_map_door_1.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   drop = 'sss_map:door_1_closed',
   wield_scale = {x = .5, y = .5, z = .5},
   walkable = false,
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.25, .5, 1.5, .25},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.25, .5, 1.5, .25},
      },
   groups = {breakable=1, not_in_creative_inventory=1, door=1},
   after_destruct = function(pos)
      pos.y = pos.y+1
      minetest.remove_node(pos)
   end
})

minetest.register_node('sss_map:door_1_closed', {
   description = 'Closed Door (1 wide)',
   drawtype = 'mesh',
   mesh = 'sss_map_door_1_closed.obj',
   tiles = {'sss_map_door_1_closed.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   wield_scale = {x = .5, y = .5, z = .5},
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.25, .5, 1.5, .25},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.25, .5, 1.5, .25},
      },
   groups = {breakable=1, door=1},
   on_rightclick = function(pos, node, clicker)
      door_opening(pos, node, clicker, 'sss_map:door_1', 'sss_map:door_1_closed')
   end,
   after_place_node = function(pos)
      local node = minetest.get_node(pos)
      pos.y = pos.y+1
      minetest.set_node(pos, {name = 'sss_map:door_1_invisible', param2 = node.param2})
   end,
   after_destruct = function(pos)
      pos.y = pos.y+1
      minetest.remove_node(pos)
   end
})

minetest.register_node('sss_map:door_1_invisible', {
   description = 'empty node :P',
   drawtype = 'airlike',
   walkable = false,
   drop = '',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -1.5, 0, .5, .5, .25},
      },
   groups = {not_in_creative_inventory = 1, breakable=1, door=2},
   on_rightclick = function(pos, node, clicker)
      pos.y = pos.y-1
      door_opening(pos, node, clicker, 'sss_map:door_1', 'sss_map:door_1_closed')
   end,
   after_destruct = function(pos)
      pos.y = pos.y-1
      minetest.remove_node(pos)
   end
})


minetest.register_node('sss_map:door_2', {
   description = 'Door (2 wide)',
   drawtype = 'mesh',
   mesh = 'sss_map_door_2.obj',
   tiles = {'sss_map_door_2.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   drop = 'sss_map:door_2_closed',
   wield_scale = {x = .5, y = .5, z = .5},
   walkable = false,
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.25, 1.5, 1.5, .25},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.25, 1.5, 1.5, .25},
      },
   groups = {breakable=1, not_in_creative_inventory=1, door=1},
   after_destruct = function(pos)
      pos.y = pos.y+1
      minetest.remove_node(pos)
   end
})

minetest.register_node('sss_map:door_2_closed', {
   description = 'Closed Door (2 wide)',
   drawtype = 'mesh',
   mesh = 'sss_map_door_2_closed.obj',
   tiles = {'sss_map_door_2_closed.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   wield_scale = {x = .5, y = .5, z = .5},
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.25, 1.5, 1.5, .25},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.25, 1.5, 1.5, .25},
      },
   groups = {breakable=1, door=1},
   on_rightclick = function(pos, node, clicker)
      door_opening(pos, node, clicker, 'sss_map:door_2', 'sss_map:door_2_closed')
   end,
   after_place_node = function(pos)
      local node = minetest.get_node(pos)
      pos.y = pos.y+1
      minetest.set_node(pos, {name = 'sss_map:door_2_invisible', param2 = node.param2})
   end,
   after_destruct = function(pos)
      pos.y = pos.y+1
      minetest.remove_node(pos)
   end
})

minetest.register_node('sss_map:door_2_invisible', {
   description = 'empty node :P',
   drawtype = 'airlike',
   walkable = false,
   drop = '',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -1.5, 0, 1.5, .5, .25},
      },
   groups = {not_in_creative_inventory = 1, breakable=1, door=2},
   on_rightclick = function(pos, node, clicker)
      pos.y = pos.y-1
      door_opening(pos, node, clicker, 'sss_map:door_2', 'sss_map:door_2_closed')
   end,
   after_destruct = function(pos)
      pos.y = pos.y-1
      minetest.remove_node(pos)
   end
})

minetest.register_node('sss_map:door_3', {
   description = 'Door (3 wide)',
   drawtype = 'mesh',
   mesh = 'sss_map_door_3.obj',
   tiles = {'sss_map_door_3.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   drop = 'sss_map:door_3_closed',
   wield_scale = {x = .5, y = .5, z = .5},
   walkable = false,
   selection_box = {
      type = 'fixed',
      fixed = {-1.5, -.5, -.25, 1.5, 1.5, .25},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-1.5, -.5, -.25, 1.5, 1.5, .25},
      },
   groups = {breakable=1, not_in_creative_inventory=1, door=1},
   after_destruct = function(pos)
      pos.y = pos.y+1
      minetest.remove_node(pos)
   end
})

minetest.register_node('sss_map:door_3_closed', {
   description = 'Closed Door (3 wide)',
   drawtype = 'mesh',
   mesh = 'sss_map_door_3_closed.obj',
   tiles = {'sss_map_door_3_closed.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   wield_scale = {x = .5, y = .5, z = .5},
   selection_box = {
      type = 'fixed',
      fixed = {-1.5, -.5, -.25, 1.5, 1.5, .25},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-1.5, -.5, -.25, 1.5, 1.5, .25},
      },
   groups = {breakable=1, door=1},
   on_rightclick = function(pos, node, clicker)
      door_opening(pos, node, clicker, 'sss_map:door_3', 'sss_map:door_3_closed')
   end,
   after_place_node = function(pos)
      local node = minetest.get_node(pos)
      pos.y = pos.y+1
      minetest.set_node(pos, {name = 'sss_map:door_3_invisible', param2 = node.param2})
   end,
   after_destruct = function(pos)
      pos.y = pos.y+1
      minetest.remove_node(pos)
   end
})

minetest.register_node('sss_map:door_3_invisible', {
   description = 'empty node :P',
   drawtype = 'airlike',
   walkable = false,
   drop = '',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-1.5, -1.5, 0, 1.5, .5, .25},
      },
   groups = {not_in_creative_inventory = 1, breakable=1, door=2},
   on_rightclick = function(pos, node, clicker)
      pos.y = pos.y-1
      door_opening(pos, node, clicker, 'sss_map:door_3', 'sss_map:door_3_closed')
   end,
   after_destruct = function(pos)
      pos.y = pos.y-1
      minetest.remove_node(pos)
   end
})
