minetest.register_node('sss_map:cyrogenic_pod', {
   description = 'Cyrogenic Pod',
   drawtype = 'mesh',
   mesh = 'sss_map_cyrogenic_pod.obj',
   tiles = {'sss_map_cyrogenic_pod.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {{-.5, -.5, -.8, .5, 0, 1.5},
               {-.5, 0, -.4, .5, 1, 1.25}
      }},
   collision_box = {
      type = 'fixed',
      fixed = {{-.5, -.5, -.8, .5, 0, 1.5},
               {-.5, 0, -.4, .5, 1, 1.25}
      }},
   groups = {breakable=1},
   on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
      sss_core.gen_crew_data(pos)
      local clicker_pos = clicker:get_pos()
      local param2 = node.param2
      local name = clicker:get_player_name()
      --There MUST be a better way to make this work, but I've spent far too much time trying to use vectors. This will have to do.
      if param2 == 0 and clicker_pos.z > pos.z+2 and math.abs(clicker_pos.x - pos.x) < 1 then
         minetest.show_formspec(name, 'sss_core:cyrogenic_pod', sss_core.cyrogenic_pod(pos))
      elseif param2 == 1 and clicker_pos.x > pos.x+2 and math.abs(clicker_pos.z - pos.z) < 1 then
         minetest.show_formspec(name, 'sss_core:cyrogenic_pod', sss_core.cyrogenic_pod(pos))
      elseif param2 == 2 and clicker_pos.z < pos.z-2 and math.abs(clicker_pos.x - pos.x) < 1 then
         minetest.show_formspec(name, 'sss_core:cyrogenic_pod', sss_core.cyrogenic_pod(pos))
      elseif param2 == 3 and clicker_pos.x < pos.x-2 and math.abs(clicker_pos.z - pos.z) < 1 then
         minetest.show_formspec(name, 'sss_core:cyrogenic_pod', sss_core.cyrogenic_pod(pos))
      end
   end,
})


local tool_list = {
   'sss_items:mech_tool_1',
   'sss_items:mech_tool_2',
   'sss_items:mech_tool_3',
   'sss_items:rations_1',
}

local function select_item()
   local max = #(tool_list)
   local key = math.random(1,max)
   local name = tool_list[key]
   return name
end

minetest.register_node('sss_map:tool_chest', {
   description = 'Tool Chest',
   drawtype = 'mesh',
   mesh = 'sss_map_tool_chest.obj',
   tiles = {'sss_map_tool_chest.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {{-.4357, -.5, -.375, 1.4375, .5, .4375},
               {-.375, .5, -.3125, 1.375, 1.25, .4375}
      }},
   collision_box = {
      type = 'fixed',
      fixed = {{-.5, -.5, -.5, 1.5, .5, .5},
               {-.4357, .5, -.3125, 1.4375, 1, .4375}
      }},
   groups = {breakable=1},
   on_rightclick = function(pos, node, clicker)
      local item = select_item()
      local player_inv = clicker:get_inventory()
      if player_inv:room_for_item('main', item) then
         player_inv:add_item('main', item)
      else
         minetest.chat_send_player(clicker:get_player_name(), 'You find a tool, but have no space to store it.')
      end
   end,
})

minetest.register_node('sss_map:ladder', {
   description = 'Ladder',
   drawtype = 'mesh',
   mesh = 'sss_map_ladder.obj',
   tiles = {'sss_map_ladder.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   walkable = false,
   climbable = true,
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, .25, .5, .5, .5}
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, .5, .5, .5}
      },
   groups = {breakable=1},
})

minetest.register_node('sss_map:table_basic', {
   description = 'Basic Table',
   drawtype = 'mesh',
   mesh = 'sss_map_table_basic.obj',
   tiles = {'sss_map_table_basic.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, 1.5, .5, .5},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, 1.5, .5, .5},
      },
   groups = {breakable=1}
})

minetest.register_node('sss_map:stool', {
   description = 'Short stool',
   drawtype = 'mesh',
   mesh = 'sss_map_stool.obj',
   tiles = {'sss_map_stool.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.25, -.5, -.25, .25, .0625, .25},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.25, -.5, -.25, .25, .0625, .25},
      },
   groups = {breakable=1}
})

minetest.register_node('sss_map:sofa', {
   description = 'Sofa',
   drawtype = 'mesh',
   mesh = 'sss_map_sofa.obj',
   tiles = {'sss_map_sofa.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {
         {-.375, -.5, -.375, 1.375, 0, .4375},
         {-.375, -.4375, .3125, 1.375, .4375, .5}
         }
      },
   collision_box = {
      type = 'fixed',
      fixed = {
         {-.375, -.5, -.375, .375, 0, .375},
         {-.375, 0, .375, .375, .5, .5}
         }
      },
   groups = {breakable=1}
})

minetest.register_node('sss_map:trash_bin', {
   description = 'Trash Bin',
   drawtype = 'mesh',
   mesh = 'sss_map_trash_bin.obj',
   tiles = {'sss_map_trash_bin.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.375, -.5, -.375, .375, .5, .375},
   },
   collision_box = {
      type = 'fixed',
      fixed = {-.375, -.5, -.375, .375, .5, .375},
   },
   groups = {breakable=1},
   on_rightclick = function(pos, node, clicker, itemstack)
      itemstack:take_item(1)
      return itemstack
   end,
})

minetest.register_node('sss_map:water_cooler', {
   description = 'Water Cooler',
   drawtype = 'mesh',
   mesh = 'sss_map_water_cooler.obj',
   tiles = {'sss_map_water_cooler.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.375, -.5, -.3125, .375, 1.5, .4375},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.45, -.5, -.5, .45, 1.5, .45},
      },
   groups = {breakable=1}
})

minetest.register_node('sss_map:sleeping_mat', {
   description = 'Sleeping Mat',
   drawtype = 'mesh',
   mesh = 'sss_map_sleeping_mat.obj',
   tiles = {'sss_map_sleeping_mat.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, 1.5, -.25, .5},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, 1.5, -.25, .5},
      },
   groups = {breakable=1}
})


local inventory_list = {
   'sss_items:coil_core',
   'sss_items:difference_filter',
   'sss_items:fuel_filter',
   'sss_items:plasma_chamber',
   'sss_items:reduction_chamber',
   'sss_items:rations_3'
}

local function select_item()
   local max = #(inventory_list)
   local key = math.random(1,max)
   local name = inventory_list[key]
   return name
end

local function is_first_free_slot(player, index) --Make this a global function, as all the right clicks need it.
   local player_inv = player:get_inventory()
   local first_free = index+1
   for i = 1, index, 1 do
      local curstk = player_inv:get_stack('main', i)
      if curstk:is_empty() and i < first_free then
         first_free = i
         break
      end
   end
   return (first_free == index)
end

local function storage_on_rightclick(pos, node, clicker, wielded)
   local meta = minetest.get_meta(pos)
   local has_item = meta:get_string('item')
   if has_item == '' then
      local pos1 = {x=pos.x-20, y=pos.y-2, z=pos.z-20}
      local pos2 = {x=pos.x+20, y=pos.y+2, z=pos.z+20}
      local nodes = minetest.find_nodes_in_area(pos1, pos2, {'group:storage_rack'})
      for i = 1, #nodes do
         local chosen_pos = nodes[i]
         local meta = minetest.get_meta(chosen_pos)
         local item = meta:get_string('item')
         if item == '' then
            meta:set_string('item', select_item())
         end
      end
   elseif has_item == 'none' then
       --do nothing
   else
      local player_inv = clicker:get_inventory()
      if player_inv:room_for_item('main', has_item) then
         local wield_slot = is_first_free_slot(clicker, clicker:get_wield_index())
         player_inv:add_item('main', has_item)
         local inv_name = ItemStack(has_item)
         meta:set_string('infotext', inv_name:get_description())
         if wielded:is_empty() and wield_slot then
            return ItemStack(has_item)
         end
      else
         minetest.chat_send_player(clicker:get_player_name(), 'You find a something, but have no space to store it.')
      end
   end
end

minetest.register_node('sss_map:storage_rack_1', {
   description = 'Storage Rack',
   drawtype = 'mesh',
   mesh = 'sss_map_storage_rack_1.obj',
   tiles = {'sss_map_storage_rack_1.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   groups = {breakable=1, storage_rack=1},
   on_rightclick = storage_on_rightclick
})

for i = 2, 4 do

   minetest.register_node('sss_map:storage_rack_'..i, {
      description = 'Storage Rack',
      drawtype = 'mesh',
      mesh = 'sss_map_storage_rack_2.obj',
      tiles = {'sss_map_storage_rack_'..i..'.png'},
      paramtype = 'light',
      paramtype2 = 'facedir',
      groups = {breakable=1, storage_rack=1},
      on_rightclick = storage_on_rightclick
   })

end

minetest.register_lbm({
   label = 'Shuffle Storage Racks',
   name = 'sss_map:storage_rack',
   run_at_every_load = false,
   nodenames = {'group:storage_rack'},
   action = function(pos, node)
      local version = math.random(4)
      minetest.set_node(pos, {name= 'sss_map:storage_rack_'..version, param2 = node.param2})
   end
})
