minetest.register_chatcommand('spawn', {
   description = 'takes player to spawn',
   func = function(name)
      local player = minetest.get_player_by_name(name)
      player:set_pos({x=110,y=12,z=46})
   end
})

minetest.register_chatcommand('power_level', {
   params = '<power_level>',
   description = 'Changes the ship\'s power level.',
   privs = {enable_cheats = true},
   func = function(name, param)
      if sss_core.is_integer(param) then
         sss_core.savedata.power_level = tonumber(param)
         minetest.chat_send_player(name, 'Set ship\'s power level to '..param)
      else
         minetest.chat_send_player(name, 'Malformed input data!')
      end
   end,
})

minetest.register_chatcommand('security_level', {
   params = '<security_level>',
   description = 'Changes your security level.',
   privs = {enable_cheats = true},
   func = function(name, param)
      if sss_core.is_integer(param) then
         local player = minetest.get_player_by_name(name)
         local player_meta = player:get_meta()
         player_meta:set_int('security_level', param)
         minetest.chat_send_player(name, 'Set your security level to '..param)
      else
         minetest.chat_send_player(name, 'Malformed input data!')
      end
   end,
})
