local bg =
   'formspec_version[3]'..
   'size[14,8]'..
   'bgcolor[;neither]'..
   'background[-1,-1;16,10;sss_core_bridge_computer_bg.png]'

function sss_core.bridge_computer(pos)
   local formspec =
      bg..
      'style_type[image_button;border=false;bgimg=blank.png]'..
      'image_button[.5,.5;2,2;sss_core_terminal_ico.png;terminal;]'..
      'image_button[3,.5;2,2;sss_core_space_map_ico.png;space_map;]'..
      'image_button[5.5,.5;2,2;sss_core_radio_ico.png;radio;]'
   return formspec
end

local bridge_terminal =
   bg..
   'box[.25,1;13.75,7.5;black]'..
   'box[.25,0;13.75,1;grey]'..
   'style_type[textarea;border=true;font_size=30;textcolor=green]'..
   'style_type[image_button;border=false;bgimg=blank.png]'..
   'textarea[.5,1;17,10;;;terminal_1@shipcore:~$]'..
   'image_button[13,0;1,1;sss_core_bridge_exit.png;menu;]'

local bridge_space_map =
   bg..
   'box[.25,1;13.75,7.5;black]'..
   'box[.25,0;13.75,1;grey]'..
   'style_type[textarea;border=true;font_size=30;textcolor=orange]'..
   'style_type[image_button;border=false;bgimg=blank.png]'..
   'textarea[.5,1;17,10;;;Long range radios offline.\nConsider turning on short range radio and/or radar.]'..
   'image_button[13,0;1,1;sss_core_bridge_exit.png;menu;]'

local bridge_radio =
   bg..
   'box[.25,1;13.75,7.5;black]'..
   'box[.25,0;13.75,1;grey]'..
   'style_type[textarea;border=true;font_size=30;textcolor=orange]'..
   'style_type[image_button;border=false;bgimg=blank.png]'..
   'image_button[13,0;1,1;sss_core_bridge_exit.png;menu;]'..
   'hypertext[.5,1;7,7;;<global halign=left><style color=#085c8d size=30>Can we get a status report please?\n\n 10-4 \n\n Roger that. \n\n <style>]'..
   'hypertext[6.75,2;7,7;;<global halign=right><style color=#8d0808 size=30>All is well.\n\n We\'ve got a storm approaching fast, will keep you updated.\n\n Took some damage, sending out a crew to see how bad it is. \n Hello???\n Anybody there?<style>]'

minetest.register_on_player_receive_fields(function(player, formname, fields)
   local name = player:get_player_name()
   if formname == 'sss_core:bridge_computer' then
      if fields.terminal then
         minetest.show_formspec(name, 'sss_core:bridge_computer', bridge_terminal)
      elseif fields.space_map then
         minetest.show_formspec(name, 'sss_core:bridge_computer', bridge_space_map)
      elseif fields.radio then
         minetest.show_formspec(name, 'sss_core:bridge_computer', bridge_radio)
      elseif fields.menu then
         minetest.show_formspec(name, 'sss_core:bridge_computer', sss_core.bridge_computer(pos))
      end
   end
end)
