local esc = minetest.formspec_escape
local modstorage = minetest.get_mod_storage()

local bg_screen = --32px resolution
   'formspec_version[3]'..
   'size[18,12]'..
   'bgcolor[;neither]'..
   'background[-1,-1;20,14;sss_core_terminal_bg.png]'..
   'style_type[image_button;border=false;bgimg=blank.png]'..
   'image_button[17,0;1,1;sss_core_back_ico.png;login;]'

function sss_core.terminal_welcome()
   local formspec =
      'formspec_version[3]'..
      'size[18,12]'..
      'bgcolor[;neither]'..
      'background[-1,-1;20,14;sss_core_terminal_bg.png]'..
      'style_type[image_button;border=false;bgimg=blank.png]'..
      'hypertext[.25,.25;17.5,4;;<global halign=center valign=middle><style color=black size=50>Scan your hand to login.<style>]'..
      'image_button[6,3;6,6;sss_core_handprint.png;login;]'
   return formspec
end

local function terminal_main(name)
   local player = minetest.get_player_by_name(name)
   local player_meta = player:get_meta()
   local security_level = player_meta:get_int('security_level') or 0
   local notifications = player_meta:get_int('notifications') or 0
   local formspec =
      bg_screen..
      'textarea[0,0;15,1;;;Version 1.3.2          You have level '..security_level..' security clearance.          '..notifications..' Notifications]'..
      'image_button[.5,1;2,2;sss_core_news_ico.png;news;]'..
      'image_button[3,1;2,2;sss_core_calendar_ico.png;calendar;]'..
      'image_button[5.5,1;2,2;sss_core_menu_ico.png;menu;]'..
      'image_button[8,1;2,2;sss_core_notepad_ico.png;notes;]'..
      'image_button[10.5,1;2,2;sss_core_ship_map_ico.png;ship_map;]'
   if security_level >= 2 then
      formspec = formspec ..
      'image_button[.5,3.5;2,2;sss_core_notification_ico.png;notifications;]'
   end
   if security_level >= 3 then
      formspec = formspec ..
      'image_button[.5,6;2,2;sss_core_map_ico.png;map;]'
   end
   if security_level >= 5 then
      formspec = formspec ..
      'image_button[.5,8.5;2,2;sss_core_ship_status_ico.png;ship_status;]'
   end
   return formspec
end

local function terminal_news()
   local formspec =
      bg_screen..
      'style_type[textarea;border=true;font_size=30;textcolor=red]'..
      'textarea[.5,1;17,10;;;   This will be the last update, it\'s unlikely anybody will ever read this. '..
      'After suffering severe damage in a solar storm we made the difficult decision to abandon ship. '..
      'We took what supplies we could with us, and jettisoned all but one escape pod. '..
      'Our goal, to make it to the settlement on Smyrna. '..
      'Should any survivors find this ship, you should make your way to the bridge as we\'ve left a few helpful items there.'..
      '\n\n\n\n\nSigning Out,\nCaptain Jeff]'
   return formspec
end

local function terminal_calendar()
   local formspec =
      bg_screen..
      'style_type[textarea;border=true;font_size=30;textcolor=black]'..
      'textarea[.5,1;17,10;;;0 Upcoming Events:]'
   return formspec
end

local function terminal_menu(name)
   local player = minetest.get_player_by_name(name)
   local player_meta = player:get_meta()
   local security_level = player_meta:get_int('security_level') or 0
   local formspec = bg_screen
   if security_level < 2 then
      formspec = formspec ..
         'style_type[textarea;border=true;font_size=30;textcolor=black]'..
         'textarea[.5,1;8,10;;;Today\'s Menu:\n\n Breakfast:\n  Pottage\n  White Bread  \n  Water\n\n'..
         'Lunch:\n  Pottage\n  White Bread  \n  Water\n\n'..
         'Super:\n  Pottage\n  White Bread  \n  Orange Juice]'..
         'textarea[9.5,1;8,10;;;Tomorrow\'s Menu:\n\n Breakfast:\n  Pottage\n  White Bread  \n  Water\n\n'..
         'Lunch:\n  Pottage\n  White Bread  \n  Water\n\n'..
         'Super:\n  Pottage\n  White Bread  \n  Orange Juice]'
   elseif security_level == 2 then
      formspec = formspec ..
         'style_type[textarea;border=true;font_size=30;textcolor=black]'..
         'textarea[.5,1;8,10;;;Today\'s Menu:\n\n Breakfast:\n  Oatmeal\n  Eggs & Toast  \n  Orange Juice\n\n'..
         'Lunch:\n  Baked Potatoes\n  Fried Chicken  \n  Orange Juice\n\n'..
         'Super:\n  Mac and Cheese\n  Hamburgers  \n  Red Wine]'..
         'textarea[9.5,1;8,10;;;Tomorrow\'s Menu:\n\n Breakfast:\n  Omlette\n  Breakfast Pizza  \n  Orange Juice\n\n'..
         'Lunch:\n  Sticky Rice\n  Meat Loaf  \n  Lemonade\n\n'..
         'Super:\n  Pizza\n  French Fries  \n  White Wine]'
   elseif security_level >= 3 then
      formspec = formspec ..
         'style_type[textarea;border=true;font_size=30;textcolor=black]'..
         'textarea[.5,1;8,10;;;Today\'s Menu:\n\n Breakfast:\n  Oatmeal\n  Eggs & Toast  \n  Orange Juice\n\n'..
         'Lunch:\n  Baked Potatoes\n  Fried Chicken  \n  Orange Juice\n\n'..
         'Super:\n  Mac and Cheese\n  Hamburgers  \n  Red Wine]'..
         'textarea[9.5,1;8,10;;;Tomorrow\'s Menu:\n\n Breakfast:\n  Omlette\n  Breakfast Pizza  \n  Orange Juice\n\n'..
         'Lunch:\n  Sticky Rice\n  Meat Loaf  \n  Lemonade\n\n'..
         'Super:\n  Filet Mignon\n  Baked Potatoes  \n  Pinot Noir]'
   end
   return formspec
end

local function terminal_notes(player)
   local content = modstorage:get_string(player:get_player_name())
   local formspec =
      bg_screen..
      'style_type[textarea;border=true;font_size=18;textcolor=black]'..
      'textarea[.25,1;17.5,10;note_content;;'..esc(content)..']'..
      'style_type[textarea;border=true;font_size=20;textcolor=red]'..
      'textarea[1,11.35;7,.6;;;BE SURE TO HIT THE SAVE BUTTON!!!]'..
      'button[7.5,11;3,1;save_player_note;Save]'
   return formspec
end

local function terminal_map()
   local formspec =
      bg_screen..
      'style_type[textarea;border=true;font_size=50;textcolor=red]'..
      'textarea[.5,1;17,10;;;   !!!Error!!! \nRadio Offline!]'..
      'image[8,2;9,9;sss_core_space_map.png]'
   return formspec
end

local function terminal_notifications(name)
   local notifications = sss_core.savedata.notifications or ''
   local formspec =
      bg_screen..
      'style_type[textarea;border=true;font_size=30;textcolor=black]'..
      'textarea[.5,1;17,10;;;Here are your notifications.\n'..notifications..']'
   return formspec
end

local function terminal_ship_map()
   local formspec =
      bg_screen..
      'image[0,1;18,11;sss_core_ship_map.png]' --Would be nice to get some sort of picture of the actual ship. Probably won't have time to do that in the game jam though.
   return formspec
end

local function terminal_ship_status() --This should pull data from the savedata, but it's endgame content, and probably won't be ready for the game jam anyway.
   local power_level = sss_core.savedata.power_level
   local formspec =
      bg_screen..
      'style_type[textarea;border=true;font_size=30;textcolor=black]'..
      'textarea[.5,1;17,10;;;Ship Status:\n Power Level: '..(power_level*33)..']'
   return formspec
end

minetest.register_on_player_receive_fields(function(player, formname, fields)
   local name = player:get_player_name()
   if formname == 'sss_core:terminal' then
      if fields.login then
         minetest.show_formspec(name, 'sss_core:terminal', terminal_main(name))
      elseif fields.news then
         minetest.show_formspec(name, 'sss_core:terminal', terminal_news())
      elseif fields.calendar then
         minetest.show_formspec(name, 'sss_core:terminal', terminal_calendar())
      elseif fields.menu then
         minetest.show_formspec(name, 'sss_core:terminal', terminal_menu(name))
      elseif fields.notes then
         minetest.show_formspec(name, 'sss_core:terminal', terminal_notes(player))
      elseif fields.map then
         minetest.show_formspec(name, 'sss_core:terminal', terminal_map())
      elseif fields.ship_map then
         minetest.show_formspec(name, 'sss_core:terminal', terminal_ship_map())
      elseif fields.ship_status then
         minetest.show_formspec(name, 'sss_core:terminal', terminal_ship_status())
      elseif fields.notifications then
         minetest.show_formspec(name, 'sss_core:terminal', terminal_notifications(name))
      elseif fields.save_player_note then
         modstorage:set_string(name, fields.note_content)
      end
   end
end)
