--[[
minetest.register_lbm({
   label = 'Turn off lights',
   name = 'sss_core:lights_out',
   run_at_every_load = true,
   nodenames = {'group:light'},
   action = function(pos, node)
      --check ship's power level
      --if low power swap lights to the off version.
      minetest.set_node(pos, {name= '', param2 = node.param2})
   end
})
]]

minetest.register_lbm({
   label = 'Close Doors',
   name = 'sss_core:close_doors',
   run_at_every_load = true,
   nodenames = {'group:door'},
   action = function(pos, node)
      local name = node.name
      if minetest.get_item_group(node.name, 'door') == 1 then
         if not string.find(name, '_closed') then
            name = name..'_closed'
            minetest.swap_node(pos, {name = name, param2 = node.param2})
         end
      end
   end
})

minetest.register_lbm({
   label = 'Clear meta from nodes that give items',
   name = 'sss_core:mechanic_nodes',
   run_at_every_load = true,
   nodenames = {'group:dispenses'},
   action = function(pos, node)
      local meta = minetest.get_meta(pos)
      meta:set_string('item', '')
   end
})
