

-- Copyright (C) 2021, 2025 Sandro del Toro

-- This file is part of Bones Minetest Mod.

-- Bones is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.

-- Bones is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.

-- You should have received a copy of the GNU Affero General Public License
-- along with Bones.  If not, see <https://www.gnu.org/licenses/>.



local S = core.get_translator(core.get_current_modname())

local bones_box = {
	type = "fixed",
	fixed = {
		-- grave
		{-5/16, 7/16, 7/16, 5/16, 8/16, 8/16},
		{-6/16, 5/16, 7/16, 6/16, 7/16, 8/16},
		{-7/16, -8/16, 7/16, 7/16, 5/16, 8/16},
		-- over base
		{-7/16, -7/16, -4/16, 7/16, -6/16, 8/16},
		{-4/16, -7/16, -4/16, 6/16, -6/16, -6/16},
		{-2/16, -7/16, -6/16, 3/16, -6/16, -7/16},
		-- base
		{-8/16, -8/16, -8/16, 8/16, -7/16, 8/16},
	}
}

local selection_box = {
	type = "fixed",
	fixed = {
		-- grave
		{-7/16, -8/16, 7/16, 7/16, 8/16, 8/16},
		-- base
		{-8/16, -8/16, -8/16, 8/16, -6/16, 8/16},
	}
}

local bones_def = {
	description = S("Bones"),
	drawtype = "nodebox",
	tiles = {
		"default_dirt.png",
		"default_dirt.png",
		"default_cobble.png",
	},
	paramtype = "light",
	paramtype2 = "facedir",
	is_ground_content = false,
	use_texture_alpha = "clip",
	sunlight_propagates = true,
	selection_box = selection_box,
	node_box = bones_box,
	stack_max = 64,
	is_ground_content = false,
	groups = {dig_immediate = 2},
	sounds = bones.sounds.node_sound_gravel_defaults(),
	drop = "",
	light_source = 8,
	_mcl_blast_resistance = 100000,
	_mcl_hardness = 0.5,
	can_dig = bones.can_dig,
	allow_metadata_inventory_move = bones.allow_metadata_inventory_move,
	allow_metadata_inventory_put = bones.allow_metadata_inventory_put,
	allow_metadata_inventory_take = bones.allow_metadata_inventory_take,
	on_metadata_inventory_take = bones.on_metadata_inventory_take,
	on_punch = bones.on_punch,
	on_timer = bones.on_timer,
	on_blast = bones.on_blast,
}

-- register node
core.register_node("bones:bones", bones_def)

-- alias
core.register_alias("mcl_bones:bones", "bones:bones")
