

-- Copyright (C) 2021, 2025 Sandro del Toro

-- This file is part of Bones Minetest Mod.

-- Bones is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.

-- Bones is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.

-- You should have received a copy of the GNU Affero General Public License
-- along with Bones.  If not, see <https://www.gnu.org/licenses/>.



local modpath = core.get_modpath(core.get_current_modname())

bones = {}

bones.sounds = mcl_sounds

bones.player_inventory_lists = { "main", "craft", "armor", "offhand" }


if core.get_modpath("named_waypoints") then
	local waypoints_def = {
		default_name = "bones",
		default_color = 0xFA364F,
		visibility_volume_radius = 300,
		visibility_volume_height = 300,
		discovery_volume_radius = 0,
	}
	named_waypoints.register_named_waypoints("bones", waypoints_def)
end

dofile(modpath .. "/functions.lua")
dofile(modpath .. "/node.lua")
