

-- Copyright (C) 2021, 2023 Ale

-- This file is part of Emeraldbank Minetest Mod.

-- Emeraldbank is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.

-- Emeraldbank is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.

-- You should have received a copy of the GNU Affero General Public License
-- along with Emeraldbank.  If not, see <https://www.gnu.org/licenses/>.



local S = core.get_translator(core.get_current_modname())


-- user /pay chat command
core.register_chatcommand("pay", {
  	params = "<player> <num>",
	description = S("Pay money to other player. Transfer your emeralds to another bank account."),
	func = function(name, param)
	   local player1 = core.get_player_by_name(name)
	   local meta1 = player1:get_meta()
	   local bankemeralds1 = meta1:get_int("emeraldbank:emerald")
	   local playername2, stringnum = param:match("([^ ]+) (.+)")
	   local player2
	   local num = tonumber(stringnum)
	   if playername2 and num then
	      player2 = core.get_player_by_name(playername2)
	   end
	   if player2 and num then
	      if num > 0 then
		 if bankemeralds1 >= num then
		    core.chat_send_player(name, S("Pay Successfully! You have transferred @1 Emeralds." , num) )
		    core.chat_send_player(playername2, S("Pay Successfully! You've gotten @1 Emeralds.", num) )
		    if core.get_modpath("irc") and irc.saysec then
		       irc.saysec(name.." has transferred "..num.." emeralds to "..playername2)
		    end
		    if core.get_modpath("yl_matterbridge") and yl_matterbridge.send_to_sec then
		       yl_matterbridge.send_to_sec("", name.." has transferred "..num.." emeralds to "..playername2)
		    end
		    emeraldbank.add_emeralds(player1, -num)
		    emeraldbank.add_emeralds(player2, num)
		    core.sound_play("cash", {
		       to_player = playername2,
		       gain = 1.0,
		       fade = 0.0,
		       pitch = 1.0,
		    })
		 else
		    core.chat_send_player(name, S("Not enough Emeralds in your account"))
		 end
	      else
		 core.chat_send_player(name, S("Invalid pay"))
	      end
	      return true
	   end
	   return false
	end
})

-- admin chat command
core.register_chatcommand("emeralds", {
  	params = "<player> <num>",
	description = S("Admin Command! Add player emeralds in bank account, also can use negative numbers"),
	privs = {server=true},		     
	func = function(name, param)
	   local playername, stringnum = param:match("([^ ]+) (.+)")
	   local player
	   local num = tonumber(stringnum)
	   if playername and num then
	      player = core.get_player_by_name(playername)
	   end
	   if player and num then
	      emeraldbank.add_emeralds(player, num)
	      return true
	   end
	   return false
	end
})
