

-- Copyright (C) 2021, 2022 Ale

-- This file is part of Emeraldbank Minetest Mod.

-- Emeraldbank is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.

-- Emeraldbank is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.

-- You should have received a copy of the GNU Affero General Public License
-- along with Emeraldbank.  If not, see <https://www.gnu.org/licenses/>.



local S = core.get_translator(core.get_current_modname())

local bankcraft = core.settings:get_bool("emeraldbank.bank_craft") or true


function emeraldbank.add_emeralds(player, num)
   if not player then return false end
   local meta = player:get_meta()
   local bankemeralds = meta:get_int("emeraldbank:emerald") -- if nil "get_int()" return 0 Magic!
   local name = player:get_player_name()
   if num then
      meta:set_int("emeraldbank:emerald", bankemeralds+num)
      mcl_title.set(player, "actionbar", {text=S("Emeralds in Bank: @1", bankemeralds+num), color="yellow"})
      return true
   end
   return false
end

function emeraldbank.keep(player, itemstack)
   local itemname = itemstack:get_name()
   local itemcount = itemstack:get_count()
   local name = player:get_player_name()
   if itemname == "mcl_core:emerald" then
      itemstack:take_item(itemcount)
      emeraldbank.add_emeralds(player, itemcount)
      return true
   end
   if itemname == "mcl_core:emeraldblock" then
      itemstack:take_item(itemcount)
      emeraldbank.add_emeralds(player, itemcount*9)
      return true
   end
   mcl_title.set(player, "actionbar", {text=S("You need keep emeralds or emeraldblocks in your hand!"), color="dark_red"})
   return false
end

function emeraldbank.take(player)
   local meta = player:get_meta()
   local bankemeralds = meta:get_int("emeraldbank:emerald")
   local name = player:get_player_name()
   local pos = player:get_pos()
   local num = 1
   if bankemeralds >= 1 then
      if bankemeralds >= 10 then
	 num = 10
      end
      emeraldbank.add_emeralds(player, -num)
      core.add_item(pos, "mcl_core:emerald "..num)
      return true
   end
   mcl_title.set(player, "actionbar", {text=S("Not enough Emeralds in your account"), color="dark_red"})
   return false
end


-- register bank node
core.register_node("emeraldbank:bank", {
	description = S("Emerald Bank"),
	_doc_items_longdesc = S("This block can keep your emeralds."),
	is_ground_content = false,
	tiles = {
	   "default_steel_block.png",
	   "default_steel_block.png",
	   "default_steel_block.png^mcl_core_emerald.png"
	},
	stack_max = 64,
	groups = {pickaxey=1, handy=1, building_block=1},
	sounds = mcl_sounds.node_sound_metal_defaults(),
	_mcl_blast_resistance = 5,
	_mcl_hardness = 1,

	on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
	   emeraldbank.keep(clicker, itemstack)
	end,

	on_punch = function(pos, node, puncher, pointed_thing)
	   emeraldbank.take(puncher)
	end,
})



if bankcraft then
   core.register_craft({
	 output = "emeraldbank:bank",
	 recipe = {
	    {"mcl_core:emerald", "mcl_core:emerald", "mcl_core:emerald"},
	    {"mcl_core:emerald", "mcl_core:ironblock", "mcl_core:emerald"},
	    {"mcl_core:emerald", "mcl_core:emerald", "mcl_core:emerald"},
	 }
   })
end
