

-- Copyright (C) 2021, 2023 Ale

-- This file is part of Emeraldbank Minetest Mod.

-- Emeraldbank is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.

-- Emeraldbank is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.

-- You should have received a copy of the GNU Affero General Public License
-- along with Emeraldbank.  If not, see <https://www.gnu.org/licenses/>.



local S = core.get_translator(core.get_current_modname())


local income_count = tonumber(core.settings:get("emeraldbank.income_count")) or 1
local income_period = tonumber(core.settings:get("emeraldbank.income_period")) or 1800

local timer = 0

core.register_globalstep(function(dtime)
      timer = timer + dtime;
      if timer >= income_period then
	 timer = 0
	 for _, player in ipairs(core.get_connected_players()) do
	    if not player or player.is_fake_player then return end
	    local name = player:get_player_name()
	    core.chat_send_player(name, S("You have earned @1 emeralds in your bank account!", income_count))
	    emeraldbank.add_emeralds(player, income_count)
	 end
      end
end)
