

-- Copyright (C) 2021, 2023 Ale

-- This file is part of Emeraldbank Minetest Mod.

-- Emeraldbank is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.

-- Emeraldbank is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.

-- You should have received a copy of the GNU Affero General Public License
-- along with Emeraldbank.  If not, see <https://www.gnu.org/licenses/>.



local S = core.get_translator(core.get_current_modname())

function emeraldbank.get_emeralds(name)
	atm.read_account(name)
	return atm.balance[name]
end

function emeraldbank.add_emeralds(player, num)
   if not player then return false end
   local meta = player:get_meta()
   local name = player:get_player_name()
   atm.read_account(name)
   if num then
      if atm.balance[name] then
	 atm.balance[name] = math.floor(atm.balance[name] + num)
      else
	 atm.balance[name] = num
      end
      mcl_title.set(player, "actionbar", {text=S("Emeralds in Bank: @1", atm.balance[name]), color="yellow"})
      atm.save_account(name)
      return true
   end
   return false
end

function emeraldbank.update_accounts()
   for _, player in ipairs(minetest.get_connected_players()) do
      if not player or player.is_fake_player then return end
      local meta = player:get_meta()
      local bankemeralds = meta:get_int("emeraldbank:emerald")
      if bankemeralds > 0 then
	      emeraldbank.add_emeralds(player, bankemeralds)
	      meta:set_int("emeraldbank:emerald", 0)
	      return true
      end
      return false
   end
end

function emeraldbank.inv_emeralds_to_stonks(pos)
   local meta = core.get_meta(pos)
   local inv = meta:get_inventory()
   local stonks = meta:get_int("stonks")
   local fancy_inv = inv:get_list("main")
   if not fancy_inv then return end
   local has_emerald = inv:contains_item("main", "mcl_core:emerald 1", true)
   if has_emerald then
      meta:set_int("stonks", stonks+1)
      inv:remove_item("main", "mcl_core:emerald 1")
      emeraldbank.inv_emeralds_to_stonks(pos)
      return true
   else
      return false
   end
end

function emeraldbank.get_stonks(pos)
   local meta = core.get_meta(pos)
   local owner = meta:get_string("owner")
   local player = core.get_player_by_name(owner)
   local is_online = core.player_exists(owner)
   emeraldbank.inv_emeralds_to_stonks(pos)
   local stonks = meta:get_int("stonks")
   if not player or player.is_fake_player then return end
   if is_online and stonks > 0 then
      core.sound_play("cash", {
	 to_player = owner,
	 gain = 1.0,
	 fade = 0.0,
	 pitch = 1.0,
      })
      emeraldbank.add_emeralds(player, stonks)
      meta:set_int("stonks", 0)
      core.chat_send_player(owner, S("You've earned @1 Emeralds with your shops.", stonks))
   end
end

function emeraldbank.transfer_emeralds(player1, player2, num)
   local name = player1:get_player_name()
   local name2 = player2:get_player_name()
   atm.read_account(name)
   local bankemeralds1 = atm.balance[name]
   if num > 0 then
      if bankemeralds1 and bankemeralds1 >= num then
	 core.chat_send_player(name, S("Pay Successfully! You have transferred @1 Emeralds." , num))
	 core.chat_send_player(name2, S("Pay Successfully! You've gotten @1 Emeralds.", num))
	 local msg = S("@1 has transferred @2 emeralds to @3", name, num, name2)
	 if core.get_modpath("irc") then
	    irc.say(msg)
	 end
	 if core.get_modpath("yl_matterbridge") then
		 yl_matterbridge.send_to_bridge("EMERALDBANK", msg)
	 end
	 if core.get_modpath("beerchat") then
		 beerchat.on_channel_message(beerchat.main_channel_name, "EMERALDBANK", msg)
	 end
	 emeraldbank.add_emeralds(player1, -num)
	 emeraldbank.add_emeralds(player2, num)
	 core.sound_play("cash", {
	    to_player = name2,
	    gain = 1.0,
	    fade = 0.0,
	    pitch = 1.0,
	 })
      else
	 core.chat_send_player(name, S("Not enough Emeralds in your account"))
      end
   else
      core.chat_send_player(name, S("Invalid pay"))
   end
end

function emeraldbank.upgrade_shop(pos)
   local oldnode = core.get_node(pos)
   local old_meta = core.get_meta(pos)
   local old_meta_table = core.get_meta(pos):to_table()
   local nodename = core.get_node(pos).name
   local old_inv = old_meta:get_inventory()
   local old_list = old_inv:get_list("stock")
   local old_stack = old_inv:get_stack("stock", 1)
   
   -- set the new shop node
   core.swap_node(pos, {name = "fancy_vend:player_vendor"})
   
   -- setup the new shop node
   -- Set variables for access later (for various checks, etc.)
   
   pos.y = pos.y + 1
   -- local above_node = minetest.get_node(pos).name
   
   -- -- If node above is air or the display node, and it is not protected, attempt to place the vendor. If vendor sucessfully places, place display node above, otherwise alert the user
   -- if (minetest.registered_nodes[above_node].buildable_to or above_node == "fancy_vend:display_node") and not minetest.is_protected(pos, owner) then
   --    if above_node ~= "fancy_vend:display_node" then
   -- 	 minetest.set_node(pos, minetest.registered_nodes["fancy_vend:display_node"])
   --    end
   
   -- Set owner
   local owner = old_meta:get_string("owner") or ""
   local meta = minetest.get_meta(pos)
   meta:set_string("owner", owner)
   
   -- Set default meta
   meta:set_string("log", minetest.serialize({"Vendor placed by "..owner,}))
   emeraldbank.reset_vendor_settings(pos)
   emeraldbank.refresh_vendor(pos)
   
   if minetest.get_modpath("pipeworks") then
      pipeworks.after_place(pos)
   end
   
   -- copy old metadata in new node
   core.get_meta(pos):from_table(old_meta_table)
   
   -- new node
   local node = core.get_node(pos)
   local meta = core.get_meta(pos)
   local count = meta:get_int("count")
   local price = meta:get_int("price")
   local shop_item = meta:get_string("shop_item")
   local settings = emeraldbank.get_vendor_settings(pos)

   -- settings
   settings.input_item = "mcl_core:emerald"
   settings.input_item_qty = price
   settings.output_item = shop_item
   settings.output_item_qty = count

   -- inv
   -- local inv = meta:get_inventory()
   -- inv:set_size("main", 15*6)
   -- inv:set_size("wanted_item", 1*1)
   -- inv:set_size("given_item", 1*1)
   -- inv:set_stack("main", i, old_stack)
   
   
   emeraldbank.set_vendor_settings(pos, settings)
   emeraldbank.refresh_vendor(pos)
end
