

-- Copyright (C) 2021, 2023 Ale

-- This file is part of Emeraldbank Minetest Mod.

-- Emeraldbank is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.

-- Emeraldbank is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.

-- You should have received a copy of the GNU Affero General Public License
-- along with Emeraldbank.  If not, see <https://www.gnu.org/licenses/>.



local S = core.get_translator(core.get_current_modname())


-- user /pay chat command
core.register_chatcommand("pay", {
  	params = "<player> <num>",
	description = S("Pay money to other player. Transfer your emeralds to another bank account."),
	func = function(name, param)
   	   local player1 = core.get_player_by_name(name)
	   local name2, stringnum = param:match("([^ ]+) (.+)")
	   local player2
	   local num = tonumber(stringnum)
	   if name2 and num then
	      player2 = core.get_player_by_name(name2)
	   end
	   if player2 and num then
	      return emeraldbank.transfer_emeralds(player1, player2, num)
	   end
	   return false
	end
})

-- user /money chat command
core.register_chatcommand("money", {
	description = S("Return your emeralds in your bank account."),
	func = function(name, param)
		local emeralds = emeraldbank.get_emeralds(name)
		if emeralds then
			minetest.chat_send_player(name, S("Emeralds in Bank: @1", emeralds))
			return true
		end
		return false
	end
})

-- admin chat command
core.register_chatcommand("emeralds", {
  	params = "<player> <num>",
	description = S("Admin Command! Add player emeralds in bank account, also can use negative numbers"),
	privs = {server=true},
        func = function(name, param)
           local playername, stringnum = param:match("([^ ]+) (.+)")
           local player
	   local num = tonumber(stringnum)
	   if playername and num then
	      player = core.get_player_by_name(playername)
	   end
	   if player and num then
	      emeraldbank.add_emeralds(player, num)
	      atm.read_account(playername)
	      minetest.chat_send_player(name, S("@1 has now @2 emeralds in bank account", playername, atm.balance[playername]))
	      return true
	   end
	   return false
	end
})

-- experimental upgrade command
core.register_chatcommand("upgrade", {
     description = S("Admin Command! Upgrade a shop"),
     privs = {server=true},
     func = function(name, param)
	local player = core.get_player_by_name(name)
	local pos = player:get_pos()
	local nodename = core.get_node(pos).name
	if nodename == "emeraldbank:shop" or nodename == "emeraldbank:shop_empty" then
	   emeraldbank.upgrade_shop(pos)
	   return true
	end
	return false
     end
})
