

-- Copyright (C) 2021, 2024 Sandro del Toro

-- This file is part of Emeraldbank Minetest Mod.

-- Emeraldbank is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.

-- Emeraldbank is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.

-- You should have received a copy of the GNU Affero General Public License
-- along with Emeraldbank.  If not, see <https://www.gnu.org/licenses/>.


local modname = core.get_current_modname()
local S = core.get_translator(modname)

local HUD_TIME = tonumber(core.settings:get("emeraldbank.hud_time")) or 3

--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==--==

local ad_huds = {}

local function print_emeralds()
	for _, player in ipairs(core.get_connected_players()) do
		local nm = player:get_player_name()
		local emeralds = emeraldbank.get_emeralds(nm)

		-- Already have a HUD, get rid of it
		if ad_huds[nm] and ad_huds[nm].header and ad_huds[nm].sub then
			player:hud_remove(ad_huds[nm].header)
			player:hud_remove(ad_huds[nm].sub)
		end
		
		ad_huds[nm] = {}
		
		if not emeralds then
			return
		end
		
		-- build tables
		local hud_table_header = {
			hud_elem_type = "image",
			position  = {x = 0.5, y = 0.5},
			offset    = {x = -300, y = 450},
			text      = "mcl_core_emerald.png",
			alignment = {x = -1, y = 1},
			scale     = { x = 3, y = 3},
		}
		
		local hud_table_sub = table.copy(hud_table_header)
		hud_table_sub.hud_elem_type = "text"
		hud_table_sub.offset = {
			x = hud_table_header.offset.x+30,
			y = hud_table_header.offset.y+20
		}
		hud_table_sub.scale = {x=300, y=30}
		hud_table_sub.text = "x "..emeralds
		hud_table_sub.number = 0xFFFF00
		
		-- show tables
		ad_huds[nm].header = player:hud_add(hud_table_header)
		ad_huds[nm].sub = player:hud_add(hud_table_sub)
	end
end

local ad_tick = 0.0
core.register_globalstep(function(dt)
	ad_tick = ad_tick + dt
	if ad_tick >= HUD_TIME then
		print_emeralds()
		ad_tick = 0.0
	end
end)
