

-- Copyright (C) 2021, 2024 Sandro del Toro

-- This file is part of Emeraldbank Minetest Mod.

-- Emeraldbank is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.

-- Emeraldbank is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.

-- You should have received a copy of the GNU Affero General Public License
-- along with Emeraldbank.  If not, see <https://www.gnu.org/licenses/>.



local modpath = core.get_modpath(core.get_current_modname())

emeraldbank = {}

local income_enabled = core.settings:get_bool("emeraldbank.income_enabled", true)
local start_balance = tonumber(core.settings:get("emeraldbank.start_balance")) or 30

atm = {
   balance = {},
   startbalance = start_balance,
   pending_transfers = {},
   completed_transactions = {},
   pth = minetest.get_worldpath().."/atm_accounts",
   pth_wt = minetest.get_worldpath().."/atm_wt_transactions"
}

dofile(modpath .. "/atm.lua") -- file common.lua from atm mod
dofile(modpath .. "/functions.lua")
dofile(modpath .. "/forms.lua") -- file adapted from atm mod
dofile(modpath .. "/receive_fields.lua") -- file adapted from atm mod
dofile(modpath .. "/receive_fields_wt.lua") -- file from atm mod
dofile(modpath .. "/bank.lua")
dofile(modpath .. "/commands.lua")
dofile(modpath .. "/invtab.lua")

if income_enabled then
   dofile(modpath .. "/income.lua")
end

minetest.register_on_joinplayer(emeraldbank.update_accounts)
