

-- Copyright (C) 2021, 2024 Sandro del Toro

-- This file is part of Emeraldbank Minetest Mod.

-- Emeraldbank is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.

-- Emeraldbank is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.

-- You should have received a copy of the GNU Affero General Public License
-- along with Emeraldbank.  If not, see <https://www.gnu.org/licenses/>.



local S = core.get_translator(core.get_current_modname())
local show_tab = core.settings:get_bool("emeraldbank.inv_tab", true)

-- This function must return the tab's formspec for the player
local function build(player)
	local fs = "label[1,1;"..S("Open EmeraldBank interface").."]"..
		"image_button[1,1.3;1,1;default_steel_block.png^mcl_core_emerald.png;bank;".."".."]"
	return fs
end

-- This function will be called in the on_player_receive_fields callback if the tab is currently open
-- function(player, formname, fields)
local function handle(player, fields)
	if fields.bank then
		atm.showform(player)
		return true
	end
end

-- This function will be called to know if a player can see the tab
-- Returns true by default
local function access(player)
	return show_tab
end

mcl_inventory.register_survival_inventory_tab({
      -- Page identifier
      -- Used to uniquely identify the tab
      id = "emeraldbank",
      
      -- The tab description, can be translated
      description = S("Economy"),
      
      -- The name of the item that will be used as icon
      item_icon = "mcl_core:emerald",
      
      -- If true, the main inventory will be shown at the bottom of the tab
      -- Listrings need to be added by hand
      show_inventory = true,
      
      -- This function must return the tab's formspec for the player
      build = build,
      
      -- This function will be called in the on_player_receive_fields callback if the tab is currently open
      handle = handle,
      
      -- This function will be called to know if a player can see the tab
      -- Returns true by default
      access = access,
})
