

-- Copyright (C) 2021, 2024 Sandro del Toro

-- This file is part of Emeraldbank Minetest Mod.

-- Emeraldbank is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.

-- Emeraldbank is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.

-- You should have received a copy of the GNU Affero General Public License
-- along with Emeraldbank.  If not, see <https://www.gnu.org/licenses/>.



local S = core.get_translator(core.get_current_modname())

local bankcraft = core.settings:get_bool("emeraldbank.bank_craft") or true


-- register bank node
core.register_node("emeraldbank:bank", {
	description = S("Emerald Bank"),
	_doc_items_longdesc = S("This block can keep your emeralds."),
	is_ground_content = false,
	tiles = {
	   "default_steel_block.png",
	   "default_steel_block.png",
	   "default_steel_block.png^mcl_core_emerald.png"
	},
	stack_max = 64,
	groups = {pickaxey=1, handy=1, building_block=1},
	sounds = mcl_sounds.node_sound_metal_defaults(),
	_mcl_blast_resistance = 5,
	_mcl_hardness = 1,

	on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
	   atm.showform(clicker)
	end,
})

minetest.register_alias("atm:atm", "emeraldbank:bank")


if bankcraft then
   core.register_craft({
	 output = "emeraldbank:bank",
	 recipe = {
	    {"", "mcl_core:emerald", ""},
	    {"", "mcl_core:ironblock", ""},
	    {"", "", ""},
	 }
   })
end
