

-- Copyright (C) 2021, 2024 Sandro del Toro

-- This file is part of Emeraldbank Minetest Mod.

-- Emeraldbank is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.

-- Emeraldbank is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.

-- You should have received a copy of the GNU Affero General Public License
-- along with Emeraldbank.  If not, see <https://www.gnu.org/licenses/>.


-- adapted from the income.lua file from the currency mod.

local S = core.get_translator(core.get_current_modname())


local income_count = tonumber(core.settings:get("emeraldbank.income_count")) or 1
local income_period = tonumber(core.settings:get("emeraldbank.income_period")) or 1800
local start_balance_period = tonumber(core.settings:get("emeraldbank.start_balance_period")) or 1800
local income_timer = 0
local start_balance_timer = 0

function emeraldbank.income(dtime)
   income_timer = income_timer + dtime
   local conn_players = core.get_connected_players()
   if income_timer >= income_period then
      income_timer = 0
      for _, player in ipairs(conn_players) do
         if not player or player.is_fake_player then return end
         emeraldbank.add_emeralds(player, income_count)
      end
   end

   -- Starting balance timer
   start_balance_timer = start_balance_timer + dtime
   if start_balance_timer >= start_balance_period then
      start_balance_timer = 0
      for _, player in ipairs(conn_players) do
         if not player or player.is_fake_player then return end
         local meta = player:get_meta()
         local had_start_balance = meta:get_string("emeraldbank_had_start_balance")

         if had_start_balance == "" or had_start_balance == nil then
		 emeraldbank.broadcast(player, S("You have earned your starting balance for playtime: @1", atm.startbalance), "green")
		 emeraldbank.add_emeralds(player, atm.startbalance)
		 meta:set_string("emeraldbank_had_start_balance", "true")
         end
      end
   end
end


minetest.register_globalstep(emeraldbank.income)
