

local S = core.get_translator(core.get_current_modname())

local FS = function(...) return minetest.formspec_escape(S(...)) end

-- abbreviation/symbol of the currency
local MONEY_SYMBOL = "$"


-- ATM
function atm.showform (player)
   atm.read_account(player:get_player_name())
   local formspec =
      "size[9,8.75]"..
      "label[0.5,0;" .. FS("Your account balance: @1 @2", atm.balance[player:get_player_name()], MONEY_SYMBOL) .. "]" ..
      "label[0.5,0.75;"..S("Deposit:").."]" ..
      "label[7.5,0.75;"..S("Withdraw:").."]" ..
      "item_image_button[0.5,1.25;1,1;".. "mcl_core:emerald" ..";i1;\n\n\b\b\b\b\b" .. "x1" .."]" ..
      "item_image_button[7.5,1.25;1,1;".. "mcl_core:emerald" ..";i-1;\n\n\b\b\b\b\b" .. "x1" .."]" ..
      "item_image_button[0.5,2.25;1,1;".. "mcl_core:emerald" ..";t10;\n\n\b\b\b\b" .. "x10" .."]" ..
      "item_image_button[7.5,2.25;1,1;".. "mcl_core:emerald" ..";t-10;\n\n\b\b\b\b" .. "x10" .."]" ..
      "item_image_button[0.5,3.25;1,1;".. "mcl_core:emerald" ..";c100;\n\n\b\b\b" .. "x100" .."]" ..
      "item_image_button[7.5,3.25;1,1;".. "mcl_core:emerald" ..";c-100;\n\n\b\b\b" .. "x100" .."]" ..
      "button[3.5,3;2,1;wt;"..S("Wire Transfer").."]"..
      
      "list[current_player;main;0,4.5;9,3;9]"..
      mcl_formspec.get_itemslot_bg(0,4.5,9,3)..
      "list[current_player;main;0,7.74;9,1;]"..
      mcl_formspec.get_itemslot_bg(0,7.74,9,1)..
      "listring[current_player;main]"
   
   minetest.after((0.1), function(gui)
	 return minetest.show_formspec(player:get_player_name(), "atm.form", gui)
   end, formspec)
end





-- wire transfer interface

function atm.showform_wt (player)
	atm.read_account(player:get_player_name())
	local formspec =
	"size[8,6]"..
	"button[5.75,0;2,1;transactions;" .. FS("Transactions >") .. "]" ..
	"label[2.5,0;" .. FS("Wire Transfer Terminal") .. "]" ..
	"label[2,0.5;" .. FS("Your account balance: @1 @2", atm.balance[player:get_player_name()], MONEY_SYMBOL) .. "]" ..
	"field[0.5,1.5;5,1;dstn;" .. FS("Recipient:") .. ";]" ..
	"field[6,1.5;2,1;amnt;" .. FS("Amount:") .. ";]" ..
	"field[0.5,3;7.5,1;desc;" .. FS("Description:") .. ";]" ..
	"button[4.7,5;3,1;pay;" .. FS("Complete the payment") .. "]"
	minetest.after((0.1), function(gui)
		return minetest.show_formspec(player:get_player_name(), "atm.form.wt", gui)
	end, formspec)
end

function atm.showform_wtconf(player, dstn, amnt, desc)
	atm.read_account(player:get_player_name())
	local formspec =
	"size[8,6]"..
	"label[2.5,0;" .. FS("Wire Transfer Terminal") .. "]" ..
	"label[2,0.5;" .. FS("Your account balance: @1 @2", atm.balance[player:get_player_name()], MONEY_SYMBOL) .. "]" ..
	"label[2.5,1;" .. FS("TRANSACTION SUMMARY:") .. "]" ..
	"label[0.5,1.5;" .. FS("Recipient: @1", dstn) .. "]" ..
	"label[0.5,2;" .. FS("Amount: @1", amnt) .. "]" ..
	"label[0.5,2.5;" .. FS("Description: @1", desc) .. "]" ..
	"button[4.7,5;3,1;cnfrm;" .. FS("Confirm transfer") .. "]"
	minetest.after((0.1), function(gui)
			return minetest.show_formspec(player:get_player_name(), "atm.form.wtc", gui)
		end, formspec)
end

function atm.showform_wtlist(player, tlist)
	atm.read_account(player:get_player_name())

	local textlist = ''

	if not tlist then
		textlist = FS("no transactions registered") .. "\n"
	else
		for _, entry in ipairs(tlist) do
			textlist = textlist .. entry.date .. " " .. entry.sum .. " " .. MONEY_SYMBOL ..
					" from " .. entry.from .. ": " .. entry.desc .. "\n"
		end
	end

	local formspec =
	"size[8,6]"..
	"button[5.75,0;2,1;transfer;" .. FS("< Transfer money") .. "]" ..
	"label[2.5,0;" .. FS("Wire Transfer Terminal") .. "]" ..
	"label[2,0.5;" .. FS("Your account balance: @1 @2", atm.balance[player:get_player_name()], MONEY_SYMBOL) .. "]" ..
	"textarea[0.5,1.25;7.5,4;hst;" .. FS("Transaction list") .. ";" .. textlist .. "]" ..
	"button[4.7,5;3,1;clr;" .. FS("Clear transactions") .. "]"
	minetest.after((0.1), function(gui)
			return minetest.show_formspec(player:get_player_name(), "atm.form.wtl", gui)
		end, formspec)
end
