

-- Copyright (C) 2021, 2026 Sandro del Toro

-- This file is part of Emeraldbank Minetest Mod.

-- Emeraldbank is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.

-- Emeraldbank is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.

-- You should have received a copy of the GNU Affero General Public License
-- along with Emeraldbank.  If not, see <https://www.gnu.org/licenses/>.



local S = core.get_translator(core.get_current_modname())

local FS = function(...) return core.formspec_escape(S(...)) end

-- abbreviation/symbol of the currency
local MONEY_SYMBOL = "$"


local function get_bank_fs(name, show_bal, show_inv)
	atm.read_account(name)
	local sizex = 11.75
	local bal_x, bal_y = (sizex - sizex/2 - 3/2 - 0.25), 2
	local dep_x, dep_y = 1.25, 1
	local wit_x = sizex - 1 - dep_x
	local btn_x, btn_y = (sizex - sizex/2 - 3/2), 3
	local fs =
		"formspec_version[6]"..
		"size["..sizex..",10.9]"..
		-- deposit
		"label["..dep_x..","..dep_y..";"..S("Deposit:").."]" ..
		"item_image_button["..dep_x..","..(dep_y + 0.25)..";1,1;".. "mcl_core:emerald" ..";i1;\n\b\b\b" .. "x1" .."]" ..
		"item_image_button["..dep_x..","..(dep_y + 0.25 + 1.25)..";1,1;".. "mcl_core:emerald" ..";t10;\n\b\b" .. "x10" .."]" ..
		"item_image_button["..dep_x..","..(dep_y + 0.25 + 2.5)..";1,1;".. "mcl_core:emerald" ..";c100;\n\b" .. "x100" .."]" ..
		-- withdraw
		"label["..wit_x..","..dep_y..";"..S("Withdraw:").."]" ..
		"item_image_button["..wit_x..","..(dep_y + 0.25)..";1,1;".. "mcl_core:emerald" ..";i-1;\n\b\b\b" .. "x1" .."]" ..
		"item_image_button["..wit_x..","..(dep_y + 0.25 + 1.25)..";1,1;".. "mcl_core:emerald" ..";t-10;\n\b\b" .. "x10" .."]" ..
		"item_image_button["..wit_x..","..(dep_y + 0.25 + 2.5)..";1,1;".. "mcl_core:emerald" ..";c-100;\n\b" .. "x100" .."]" ..
		-- btn
		"button["..btn_x..","..btn_y..";3,1;wt;"..S("Wire Transfer").."]"
	-- balance
	if show_bal then
		fs = fs .. "label["..bal_x..","..bal_y..";" .. FS("Your account balance:").."]"..
			"label["..(bal_x + 1.5)..","..(bal_y + 0.5)..";" .. FS("@1 @2", atm.balance[name], MONEY_SYMBOL) .. "]"
	end
	-- player inv
	if show_inv then
		fs = fs ..""..
			mcl_formspec.get_itemslot_bg_v4(0.375, 5.575, 9, 3)..
			"list[current_player;main;0.375,5.575;9,3;9]"..
			--Hotbar
			mcl_formspec.get_itemslot_bg_v4(0.375, 9.525, 9, 1)..
			"list[current_player;main;0.375,9.525;9,1;]"..
			"listring[current_player;main]"
	end
	return fs
end


function atm.showform(player)
	local name = player:get_player_name()
	atm.read_account(name)
	local formspec = get_bank_fs(name, true, true)
	core.after(0.1, function(gui)
		return core.show_formspec(player:get_player_name(), "emeraldbank:atm", gui)
	end, formspec)
end


-- wire transfer interface


function atm.showform_wt(player)
	atm.read_account(player:get_player_name())
	local pname = player:get_player_name()
	local bal_y = 0.5
	local recip_y = 2.5
	local desc_y = 4
	local btn_y = 5.2
	local formspec =
		"size[8,6]"..
		"label[0,0;" .. FS("Wire Transfer Terminal") .. "]" ..
		"button[5.75,0;2,1;transactions;" .. FS("Transactions >") .. "]" ..
		-- balance
		"label[0,"..bal_y..";" .. FS("Your account balance: @1 @2", atm.balance[pname], MONEY_SYMBOL) .. "]" ..
		-- recip, amount
		"field[0.5,"..recip_y..";5,1;dstn;" .. FS("Recipient:") .. ";]" ..
		"field[6,"..recip_y..";2,1;amnt;" .. FS("Amount:") .. ";]" ..
		-- desc
		"field[0.5,"..desc_y..";7.5,1;desc;" .. FS("Description:") .. ";]" ..
		-- button complete
		"button[3.7,"..btn_y..";4,1;pay;" .. FS("Complete the payment") .. "]"
	core.after(0.1, function(gui)
		return core.show_formspec(pname, "emeraldbank:wt", gui)
	end, formspec)
end

function atm.showform_wtconf(player, dstn, amnt, desc)
	atm.read_account(player:get_player_name())
	local title_y = 1.5
	local info_y = 2.5
	local btn_y = 5.2
	local formspec =
		"size[8,6]"..
		"label[0.5,0;" .. FS("Wire Transfer Terminal") .. "]" ..
		-- title
		"label[2,"..title_y..";" .. FS("TRANSACTION SUMMARY:") .. "]" ..
		-- balance
		"label[0.5,"..info_y..";" .. FS("Your account balance: @1 @2", atm.balance[player:get_player_name()], MONEY_SYMBOL) .. "]" ..
		-- recip, amount
		"label[0.5,"..(info_y + 0.5)..";" .. FS("Recipient: @1", dstn) .. "]" ..
		"label[0.5,"..(info_y + 1)..";" .. FS("Amount: @1", amnt) .. "]" ..
		-- desc
		"label[0.5,"..(info_y + 1.5)..";" .. FS("Description: @1", desc) .. "]" ..
		-- button complete
		"button[2.7,"..btn_y..";5,1;cnfrm;" .. FS("Confirm transfer") .. "]"
	core.after(0.1, function(gui)
		return core.show_formspec(player:get_player_name(), "emeraldbank:wtc", gui)
	end, formspec)
end

function atm.showform_wtlist(player, tlist)
	atm.read_account(player:get_player_name())
	local pname = player:get_player_name()
	local bal_y = 0.5
	local text_y = 1.7
	local text_h = 4
	local btn_y = 5.2

	local textlist = ''
	if not tlist then
		textlist = FS("no transactions registered") .. "\n"
	else
		for _, entry in ipairs(tlist) do
			local date = entry.date or "????-??-??"
			local sum = entry.sum or 0
			local desc = entry.desc or ""
			local from = entry.from or "?"
			local to = entry.to or "?"
			-- si el que mira es el emisor => mostrar "to", si no => "from"
			local dir
			if from == pname then
				dir = " to " .. to
			else
				dir = " from " .. from
			end
			textlist = textlist .. date .. " " .. sum .. "" .. MONEY_SYMBOL .. dir .. ": " .. desc .. "\n"
		end
	end

	local formspec =
		"size[8,6]"..
		"label[0,0;" .. FS("Wire Transfer Terminal") .. "]" ..
		"button[5.75,0;2,1;transfer;" .. FS("< Transfer") .. "]" ..
		-- balance
		"label[0,"..bal_y..";" .. FS("Your account balance: @1 @2", atm.balance[pname], MONEY_SYMBOL) .. "]" ..
		-- textarea
		"textarea[0.5,"..text_y..";7.5,"..text_h..";hst;" .. FS("Transaction list") .. ";" .. textlist .. "]" ..
		-- btn clear
		"button[3.7,"..btn_y..";4,1;clr;" .. FS("Clear transactions") .. "]"
	core.after(0.1, function(gui)
		return core.show_formspec(pname, "emeraldbank:wtl", gui)
	end, formspec)
end

function atm.showform2(player) return atm.showform(player) end
function atm.showform3(player) return atm.showform(player) end


-- inv tab

local function build(player)
	local name = player:get_player_name()
	--atm.read_account(name)
	local fs = get_bank_fs(name, false, false)
	return fs
end

-- This function will be called in the on_player_receive_fields callback if the tab is currently open
-- function(player, formname, fields)
local function handle(player, fields)
	emeraldbank.bank_receive_fields(player, "emeraldbank:atm", fields)
	return true
end

-- This function will be called to know if a player can see the tab
-- Returns true by default
-- local function access(player)
-- 	return true
-- end

mcl_inventory.register_survival_inventory_tab({
      -- Page identifier
      -- Used to uniquely identify the tab
      id = "emeraldbank",
      
      -- The tab description, can be translated
      description = S("Economy"),
      
      -- The name of the item that will be used as icon
      item_icon = "mcl_core:emerald",
      
      -- If true, the main inventory will be shown at the bottom of the tab
      -- Listrings need to be added by hand
      show_inventory = true,
      
      -- This function must return the tab's formspec for the player
      build = build,
      
      -- This function will be called in the on_player_receive_fields callback if the tab is currently open
      handle = handle,
      
      -- This function will be called to know if a player can see the tab
      -- Returns true by default
      --access = access,
})
