

-- Copyright (C) 2021, 2026 Sandro del Toro

-- This file is part of Emeraldbank Minetest Mod.

-- Emeraldbank is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.

-- Emeraldbank is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.

-- You should have received a copy of the GNU Affero General Public License
-- along with Emeraldbank.  If not, see <https://www.gnu.org/licenses/>.



-- Check the form
local S = core.get_translator(core.get_current_modname())

function emeraldbank.bank_receive_fields(player, form, pressed)
	if form == "emeraldbank:atm" then
		local n = player:get_player_name()
		local transaction = { amount = 0, denomination = 0, count = 0 }
		local pinv = player:get_inventory()
		
		-- single note transactions
		for _,i in pairs({1, 5, 10, 50, 100, -1, -5, -10, -50, -100}) do
			if pressed["i"..i] then
				transaction.amount = i
				transaction.denomination = '_' .. math.abs(i)
				if transaction.denomination == '_1' then
					transaction.denomination = ''
				end
				transaction.count = ' ' .. 1
				break
			end
		end
		
		-- 10x banknote transactions
		for _,t in pairs({10, 50, 100, 500, 1000, -10, -50, -100, -500, -1000}) do
			if pressed["t"..t] then
				transaction.amount = t
				transaction.denomination = '_' .. math.abs(t/10)
				if transaction.denomination == '_1' then
					transaction.denomination = ''
				end
				transaction.count = ' ' .. 10
				break
			end
		end
		
		-- 100x banknote transactions
		for _,c in pairs({100, 500, 1000, 5000, 10000, -100, -500, -1000, -5000, -10000}) do
			if pressed["c"..c] then
				transaction.amount = c
				transaction.denomination = '_' .. math.abs(c/100)
				if transaction.denomination == '_1' then
					transaction.denomination = ''
				end
				transaction.count = ' ' .. 100
				break
			end
		end
		
		if pressed.wt then
			atm.showform_wt(player)
			return
		end
		
		if (atm.balance[n] + transaction.amount) < 0 then
			core.chat_send_player(n, S("Not enough money in your account"))
			transaction.amount = 0
		end
		
		local item = "mcl_core:emerald" .. transaction.denomination .. transaction.count
		
		if transaction.amount < 0 then
			if pinv:room_for_item("main", item) then
				pinv:add_item("main", item)
				atm.balance[n] = atm.balance[n] + transaction.amount
			else
				core.chat_send_player(n, S("Not enough room in your inventory"))
			end
			
		elseif transaction.amount > 0 then
			if pinv:contains_item("main", item) then
				pinv:remove_item("main", item)
				atm.balance[n] = atm.balance[n] + transaction.amount
			else
				core.chat_send_player(n, S("Not enough money in your inventory"))
			end
		end
		
		atm.save_account(n)
		
		if not pressed.quit then
			atm.showform(player)
		end
	end
	
end

core.register_on_player_receive_fields(emeraldbank.bank_receive_fields)


function emeraldbank.wt_receive_fields(player, form, pressed)
	if form == "emeraldbank:wt" or form == "emeraldbank:wtc" or form == "emeraldbank:wtl" then
		local n = player:get_player_name()
		
		if not pressed.quit then
			if form == "emeraldbank:wt" and pressed.transactions then
				atm.read_transaction(n)
				atm.showform_wtlist(player, atm.completed_transactions[n])
				
			elseif form == "emeraldbank:wtl" and pressed.transfer then
				atm.showform_wt(player)
				
			elseif form == "emeraldbank:wtl" and pressed.clr then
				atm.read_transaction(n)
				atm.completed_transactions[n] = nil
				atm.write_transaction(n)
				core.chat_send_player(n, S("Your transaction history has been cleared"))
				atm.showform_wtlist(player, atm.completed_transactions[n])
				
			elseif form == "emeraldbank:wt" and pressed.pay then
				local wdesc = pressed.desc ~= "" and pressed.desc or S("Wire Transfer")
				atm.read_account(pressed.dstn)
				if not atm.balance[pressed.dstn] then
					core.chat_send_player(n, S("The Recipient <@1> is not registered in the banking system, aborting", pressed.dstn))
					atm.showform_wt(player)
				elseif not string.match(pressed.amnt, '^[0-9]+$') then
					core.chat_send_player(n, S("Invalid amount <@1>: must be an integer number, aborting", pressed.amnt))
					atm.showform_wt(player)
				elseif atm.balance[n] < tonumber(pressed.amnt) then
					core.chat_send_player(n, S("Your account does not have enough funds to complete this transfer, aborting"))
					atm.showform_wt(player)
				else
					atm.pending_transfers[n] = {to = pressed.dstn, sum = tonumber(pressed.amnt), desc = wdesc}
					atm.showform_wtconf(player, pressed.dstn, pressed.amnt, wdesc)
				end
				
			elseif form == "emeraldbank:wtc" and pressed.cnfrm then
				local t = atm.pending_transfers[n]
				if not t then return end
				
				local ok, err = emeraldbank.transfer(n, t.to, t.sum, t.desc, {
					kind   = t.kind   or "wire",
					mail   = (t.mail   ~= nil) and t.mail   or true,
					sound  = (t.sound  ~= nil) and t.sound  or true,
					notify = (t.notify ~= nil) and t.notify or false,
					callback = t.callback,
				})
				
				if not ok then
					if err == "insufficient_funds" then
						core.chat_send_player(n, S("Your account does not have enough funds to complete this transfer, aborting"))
					else
						core.chat_send_player(n, S("Transfer failed: @1", err))
					end
					
					if not t.extern then
						atm.showform_wt(player)
					else
						core.close_formspec(n, "emeraldbank:wtc")
					end
					return
				end
				
				core.chat_send_player(n, S("Payment of @1 to @2 completed", t.sum, t.to))
				core.chat_send_player(n, S("@1, thank you for choosing the Emerald Bank Transfer system", n))
				
				if t.extern == true then
					atm.pending_transfers[n] = nil
					core.close_formspec(n, "emeraldbank:wtc")
					return
				end
				
				atm.pending_transfers[n] = nil
				atm.showform_wt(player)
			end
		else
			if atm.pending_transfers[n] then
				atm.pending_transfers[n] = nil
			end
		end
	end
end

core.register_on_player_receive_fields(emeraldbank.wt_receive_fields)
