-- advtrains_more_slopes/init.lua


-- From advtrains/tracks.lua
local conns = function (c1, c2, r1, r2)
	return {{c = c1, y = r1}, {c = c2, y = r2}}
end


local sloped_nodebox = function (def, preset, suffix, rotation)
	local conns = preset.variant[suffix].conns
	local bot, top = conns[1].y - 0.5, conns[2].y - 0.5
	local p1, p2, p3 = (3*bot+top) / 4, (bot+top) / 2, (bot+3*top) / 4
	print(bot, top)
	return {
		selection_box = {
			type = "fixed",
			fixed = {
            {-0.5, -0.5,  -0.5, 0.5,  p1, 0.5},
            {-0.5,   p1, -0.25, 0.5,  p2, 0.5},
            {-0.5,   p2,     0, 0.5,  p3, 0.5},
            {-0.5,   p3,  0.25, 0.5, top, 0.5},
			}
		},
	}
end


local slope_descs = {
	[4] = 'uphill &d/%d',
	[5] = 'shallow uphill %d/%d',
	[6] = 'shallow uphill %d/%d',
	[7] = 'very shallow uphill %d/%d',
	[8] = 'very shallow uphill %d/%d',
}

if not advtrains.ap.t_shallow_slope then
	local variant, slopeplacer, slopeplacer_45 = {}, {max = 8}, {max = 0}
	for i = 4, slopeplacer.max do
		slopeplacer[i] = {}
		for id = 1, i do
			local bot, top = (id-1)/i, id/i
			local name = 'vst' .. i .. id
			local desc = (slope_descs[i] or 'uphill %d/%d'):format(id, i)
			variant[name] = {conns = conns(8, 0, bot, top), slope = true,
			                 desc = desc, rail_y = (bot+top)/2}
			slopeplacer[i][id] = name
		end
	end
	advtrains.ap.t_shallow_slope = {
		regstep = 1,
		variant = variant,
		regsp = true,
		slopeplacer = slopeplacer,
		slopeplacer_45 = slopeplacer_45,
		rotation = {''},
		trackworker = {},
		increativeinv = {},
	}
end


advtrains.register_tracks('default', {
	nodename_prefix = 'advtrains:dtrack_more',
	texture_prefix = 'advtrains_dtrack',
	models_prefix = 'advtrains_dtrack',
	models_suffix = '.obj',
	shared_texture = 'advtrains_dtrack_shared.png',
	second_texture = 'default_gravel.png',
	description = attrans('Track'),
	formats = {},
	get_additional_definiton = sloped_nodebox,
}, advtrains.ap.t_shallow_slope)


--[[

ADVTRAINS SUGGESTIONS:
On registering slope placer with same name as another slopeplacer, update slope
data on the already-existing one instead of overriding.

--]]
