-- advtrains_more_slopes/init.lua


local S = core.get_translator(core.get_current_modname())

local register_aliases = core.settings:get_bool('advtrains_moreslopes_register_aliases', true)
local merge_with_default = core.settings:get_bool('advtrains_moreslopes_merge_with_default', true)


-- From advtrains/tracks.lua
local conns = function (c1, c2, r1, r2)
	return {{c = c1, y = r1}, {c = c2, y = r2}}
end


local sloped_nodebox = function (def, preset, suffix, rotation)
	if string.sub(suffix, -3) == '_45' then
		-- Don't get too complicated with 45° slopes
		local top = preset.variant[suffix].rail_y - 0.5
		return {
			selection_box = {
				type = 'fixed',
				fixed = {
					{-0.4, -0.5, -0.8, 0.4, top, 0.8},
					{-0.8, -0.5, -0.4, 0.8, top, 0.4},
				}
			},
		}
	end
	local conns = preset.variant[suffix].conns
	local bot, top = conns[1].y - 0.5, conns[2].y - 0.5
	local p1, p2, p3 = (3*bot+top) / 4, (bot+top) / 2, (bot+3*top) / 4
	return {
		selection_box = {
			type = "fixed",
			fixed = {
            {-0.5, -0.5,  -0.5, 0.5,  p1, 0.5},
            {-0.5,   p1, -0.25, 0.5,  p2, 0.5},
            {-0.5,   p2,     0, 0.5,  p3, 0.5},
            {-0.5,   p3,  0.25, 0.5, top, 0.5},
			}
		},
	}
end


local slope_descs = {
	[4] = 'uphill %d/%d',
	[5] = 'shallow uphill %d/%d',
	[6] = 'shallow uphill %d/%d',
	[7] = 'very shallow uphill %d/%d',
	[8] = 'very shallow uphill %d/%d',
}

local slope_descs_45 = {
	[3] = 'shallow uphill %d/%d (45°)',
	[4] = 'shallow uphill %d/%d (45°)',
	[5] = 'very shallow uphill %d/%d (45°)',
	[6] = 'very shallow uphill %d/%d (45°)',
}

if not advtrains.ap.t_shallow_slope then
	local variant, slopeplacer, slopeplacer_45 = {}, {max = 8}, {max = 6}
	for i = 4, slopeplacer.max do
		slopeplacer[i] = {}
		for id = 1, i do
			local bot, top = (id-1)/i, id/i
			local name = 'vst' .. i .. id
			local desc = (slope_descs[i] or 'uphill %d/%d'):format(id, i)
			variant[name] = {conns = conns(8, 0, bot, top), slope = true,
			                 desc = desc, rail_y = (bot+top)/2}
			slopeplacer[i][id] = name
		end
	end
	for i = 3, slopeplacer_45.max do
		slopeplacer_45[i] = {}
		for id = 1, i do
			local bot, top = (id-1)/i, id/i
			local name = 'vst' .. i .. id .. '_45'
			local desc = (slope_descs_45[i] or 'uphill %d/%d (45°)'):format(id, i)
			variant[name] = {conns = conns(10, 2, bot, top), slope = true,
			                 desc = desc, rail_y = (bot+top)/2}
			slopeplacer_45[i][id] = name
		end
	end
	-- Begin HACKY
	if merge_with_default then
		slopeplacer[2] = {'vst1', 'vst2'}
		slopeplacer[3] = {'vst31', 'vst32', 'vst33'}
		slopeplacer_45[2] = {'vst1_45', 'vst2_45'}
	end
	-- End HACKY
	advtrains.ap.t_shallow_slope = {
		v25_format = true,
		regstep = 1,
		variant = variant,
		regsp = true,
		slopeplacer = slopeplacer,
		slopeplacer_45 = slopeplacer_45,
		rotation = {''},
		trackworker = {},
		increativeinv = {},
	}
end


local tracks = {['advtrains:dtrack_more'] = 'advtrains:dtrack'}

advtrains.register_tracks('default', {
	nodename_prefix = merge_with_default
		and 'advtrains:dtrack'
		or 'advtrains:dtrack_more',
	texture_prefix = 'advtrains_dtrack',
	models_prefix = 'advtrains_dtrack',
	models_suffix = '.obj',
	shared_texture = 'advtrains_dtrack_shared.png',
	second_texture = 'default_gravel.png',
	description = attrans('Track'),
	formats = {[7] = {true, false}, [8] = {true, false}},
	get_additional_definiton = sloped_nodebox,
}, advtrains.ap.t_shallow_slope)

if core.get_modpath('tieless_tracks') then
	tracks['advtrains:dtrack_tieless_more'] = 'advtrains:dtrack_tieless'
	advtrains.register_tracks('default', {
		nodename_prefix = merge_with_default
			and 'advtrains:dtrack_tieless'
			or 'advtrains:dtrack_tieless_more',
		texture_prefix = 'advtrains_dtrack_tieless',
		models_prefix = 'advtrains_dtrack',
		models_suffix = '.obj',
		shared_texture = 'advtrains_dtrack_tieless_shared.png',
		second_texture = 'default_gravel.png',
		description = attrans('Track (Tieless)'),
		formats = {[7] = {true, false}, [8] = {true, false}},
		get_additional_definiton = sloped_nodebox,
	 }, advtrains.ap.t_shallow_slope)
end

if register_aliases then
	for no_overwrite_name, overwrite_name in pairs(tracks) do
		for name, _ in pairs(advtrains.ap.t_shallow_slope.variant) do
			if merge_with_default then
				minetest.register_alias(no_overwrite_name .. '_' .. name,
				                        overwrite_name .. '_' .. name)
			else
				minetest.register_alias(overwrite_name .. '_' .. name,
				                        no_overwrite_name'_' .. name)
			end
		end
	end
end


--[[

ADVTRAINS SUGGESTIONS:
On registering slope placer with same name as another slopeplacer, update slope
data on the already-existing one instead of overriding.

--]]
