-- eyeball_train/init.lua


local S = core.get_translator('eb_eyeballs')


advtrains.register_coupler_type('eyeball_coupler', 'Eyeball coupler')


local register_eyeball_train = function (kind, name)
	advtrains.register_wagon(
		':advtrains:eyeball_train_' .. kind,
		{
			mesh = 'eb_eyeballs_eyeball.gltf',
			textures = {'eb_eyeballs_eyeball_' .. kind .. '_open.png'},
			drives_on = {default = true},
			max_speed = 10,
			seats = {
				{
					name = 'Driver stand',
					attach_offset = {x = 0, y = -15, z = 0},
					view_offset = {x = 0, y = -15, z = 0},
					group = 'driver_stand',
				},
			},
			seat_groups = {
				driver_stand = {
					name = 'Driver Stand',
					access_to = {},
					require_doors_open = false,
					driving_ctrl_access = true,
				},
			},
			assign_to_seat_group = {'driver_stand'},
			is_locomotive = true,
			visual_size = {x = 1.2, y = 1.2, z = 1.2},
			wagon_span = 0.5,
			coupler_types_front = {eyeball_coupler = true},
			coupler_types_back = {eyeball_coupler = true},
			collisionbox = {-0.4, -0.4, -0.4, 0.4, 0.4, 0.4},
			selectionbox = {-0.4, -0.4, -0.4, 0.4, 0.4, 0.4, rotate = true},
		},
		name,
		'eb_eyeballs_spawner_' .. kind .. '_open.png')
end


register_eyeball_train('good', S('Good Eyeball'))
register_eyeball_train('evil', S('Evil Eyeball'))
