LuaATC Textlines API
--------------------

## How to make new LuaATC Textlines

The function `luaatc_textline.register_textline(name, def)` registers a new
LuaATC textline.
* `name`: the node's name.
* `def`: the node's definition table. It should contain, among other things,
  a `luaatc_textline` table. See [LuaATC textline information table].


#### LuaATC textline information table

This is a table containing various information on the textline's capabilities:
```lua
textline_def = {
	...
	luaatc_textline
		lcd_info = {
			[0] = {delta = {x=0, y=0, z=0}, rotation = {x=0, y=0,          z=0}},
			[1] = {delta = {x=0, y=0, z=0}, rotation = {x=0, y=-math.pi/2, z=0}},
			[2] = {delta = {x=0, y=0, z=0}, rotation = {x=0, y=math.pi,    z=0}},
			[3] = {delta = {x=0, y=0, z=0}, rotation = {x=0, y=math.pi/2,  z=0}},
		},
		-- Contains position and rotation data for the text entity, depending 
		-- on the node's param2 value.
		-- /!\ If not present, your textline will not work correctly! /!\

		properties = {visual = 'mesh', mesh = 'textline_screen.obj'},
		-- Initial properties of the text entity. Can be used, among other
		-- things, to change the visual. By default it is 'upright_sprite'.
		-- Defaults to {}.

		visual_size = {x = 10, y = 10, z = 10},
		-- Visual size of the text entity.
		-- Defaults to {x = 1, y = 1, z = 1}.

		font = 'lcd',
		color = '#00C040',
		-- The font_api name of the preferred font for the textline, and the
		-- color the text should be rendered in.

		width = 162,
		height = 44,
		-- The size of the text texture for the entity.
		-- It is currently not possible to have different displays of different
		-- sizes.

		glow = 10,
		-- Makes the text entity glow. (none by default)

		displays = 2,
		-- Allows to have more than one display per textline. You should use
		-- a mesh entity (see the `properties` field) with several texture slots.
		-- The first text will go in th first slot, and so on.
	},
	...
}
```


## Function reference

`luaatc_textline.get_info(pos)`: returns the [textline information table] of
the textline at `pos`. Returns a second value, its `lcd_info` table
corresponding to the node's param2, if applicable. Returns nil if the node
at `pos` is not a LuaATC textline.

`luaatc_textline.reset_meta(pos)`: erases the text meta at `pos`.
Celled after a textline has been placed.

`luaatc_textline.refresh_size(pos, obj, visual_size)`: dynamically updates the
size and position of the text entity `obj` with visual size `visual_size`. If
`obj` is not specified, looks up for a text entity at `pos`. If `visual_size`
is not specified, looks up in the [textline information table] of the node
at `pos`.
Called when a text entity is activated.

`luaatc_textline.create_entity(pos)`: creates the text entity for the textline
at `pos`.
Called when a textline is placed, or when it notices its text entity is gone.

`luaatc_textline.setup_entity(pos, obj, info, lcd_info)`: sets up text entity
properties such as rotation, glow, and size for object `obj` at `pos`. `info`
and `lcd_info` are not necessary, but they can be passed to the function to
avoid redundant lookups.
Called when a text entity is activated.

`luaatc_textline.clear_entity(pos)`: removes any text entities at `pos`.
Called when a textline is destroyed.

`luaatc_textline.set_text(pos, text, ...)`: sets the text displayed on the
textline's displays at `pos`. Pass no more arguments to merely refresh the
text entity's texture, or as many arguments as there are displays on the
textline to update the text it displays. In the latter case displays set to
display `nil` replicate the text of the first display.
This function, without the `pos` argument, is available from the LuaATC
environment of a LuaATC textline.

`luaatc_textline.register_textline(name, def)`: registers a new LuaATC
textline. See [How to make new LuaATC Textlines] for more info.
