-- luaatc_textline/textlines.lua


local S = core.get_translator('luaatc_textline')


local has_font_lcd = luaatc_textline.use_font_api
	and font_api.registered_fonts.lcd
local lcd_box = {
    type = 'fixed',
    fixed = {-8/16, -8/16, 7/16, 8/16, 8/16, 8/16}
}
local hanging_box = {
    type = 'fixed',
    fixed = {-1.5, -0.25, -0.25, 1.5, 0.5, 0.25}
}


luaatc_textline.register_textline('luaatc_textline:textline', {
	drawtype = 'nodebox',
	description = S('LuaATC Textline'),
	inventory_image = 'luaatc_textline_icon.png',
	wield_image = 'luaatc_textline_icon.png',
	tiles = {'luaatc_textline_any.png'},
	paramtype = 'light',
	sunlight_propagates = true,
	light_source = 0,
	paramtype2 = '4dir',
	node_box = lcd_box,
	selection_box = lcd_box,
	groups = {choppy = 3, dig_immediate = 2, not_blocking_trains = 1,
	          save_in_at_nodedb = 1},

	luaatc_textline = {
		lcd_info = {
			[0] = {delta = {x = 0, y = 0, z = 0.43},
			       rotation = {x = 0, y = 0, z = 0}},
			[1] = {delta = {x = 0.43, y = 0, z = 0},
			       rotation = {x = 0, y = -math.pi / 2, z = 0}},
			[2] = {delta = {x = 0, y = 0, z = -0.43},
			       rotation = {x = 0, y = math.pi, z = 0}},
			[3] = {delta = {x = -0.43, y = 0, z = 0},
			       rotation = {x = 0, y = math.pi / 2, z = 0}},
		},
--		properties = {visual = 'sprite'},
		visual_size = {x = 3, y = 1, z = 1},
		font = 'lcd',
		width = has_font_lcd and 162 or 243,
		height = has_font_lcd and 44 or 66,
		color = '#00C040',
		glow = 10,
	},
})


minetest.register_node('luaatc_textline:background', {
	description = S('LuaATC Textline background'),
	inventory_image = 'luaatc_textline_background.png',
	wield_image = 'luaatc_textline_background.png',
	tiles = {'luaatc_textline_any.png'},
	drawtype = 'nodebox',
	node_box = lcd_box,
	selection_box = lcd_box,
	groups = {choppy = 3, dig_immediate = 2, not_blocking_trains = 1},
	paramtype = 'light',
	sunlight_propagates = true,
	light_source = 0,
	paramtype2 = '4dir',
})


luaatc_textline.register_textline('luaatc_textline:hanging_textline_green', {
	description = S('Hanging LuaATC Textline (green)'),
	drawtype = 'mesh',
	mesh = 'luaatc_textline_hanging.obj',
	tiles = {'luaatc_textline_hanging_green.png'},
	paramtype = 'light',
	sunlight_propagates = true,
	light_source = 0,
	paramtype2 = '4dir',
	selection_box = hanging_box,
	groups = {choppy = 3, dig_immediate = 2, not_blocking_trains = 1,
	          save_in_at_nodedb = 1},

	luaatc_textline = {
		lcd_info = {
			[0] = {rotation = {x = 0, y = 0, z = 0}},
			[1] = {rotation = {x = 0, y = -math.pi / 2, z = 0}},
			[2] = {rotation = {x = 0, y = math.pi, z = 0}},
			[3] = {rotation = {x = 0, y = math.pi / 2, z = 0}},
		},
		properties = {
			visual = 'mesh',
			mesh = 'luaatc_textline_hanging_screen.obj',
		},
		visual_size = {x = 10, y = 10, z = 10},
		font = 'lcd',
		width = has_font_lcd and 162 or 243,
		height = has_font_lcd and 44 or 66,
		color = '#00C040',
		glow = 10,
		displays = 2,
	},
})


luaatc_textline.register_textline('luaatc_textline:hanging_textline_orange', {
	description = S('Hanging LuaATC Textline (orange)'),
	drawtype = 'mesh',
	mesh = 'luaatc_textline_hanging.obj',
	tiles = {'luaatc_textline_hanging_orange.png'},
	paramtype = 'light',
	sunlight_propagates = true,
	light_source = 0,
	paramtype2 = '4dir',
	selection_box = hanging_box,
	groups = {choppy = 3, dig_immediate = 2, not_blocking_trains = 1,
	          save_in_at_nodedb = 1},

	luaatc_textline = {
		lcd_info = {
			[0] = {rotation = {x = 0, y = 0, z = 0}},
			[1] = {rotation = {x = 0, y = -math.pi / 2, z = 0}},
			[2] = {rotation = {x = 0, y = math.pi, z = 0}},
			[3] = {rotation = {x = 0, y = math.pi / 2, z = 0}},
		},
		properties = {
			visual = 'mesh',
			mesh = 'luaatc_textline_hanging_screen.obj',
		},
		visual_size = {x = 10, y = 10, z = 10},
		font = 'lcd',
		width = has_font_lcd and 162 or 243,
		height = has_font_lcd and 44 or 66,
		color = '#FFC000',
		glow = 10,
		displays = 2,
	},
})
