_This work is openly licensed under the terms of the
[GNU GPL 2.0 or later](https://www.gnu.org/licenses/old-licenses/gpl-2.0.html)
(for the code) and [CC-BY-SA-4.0](https://creativecommons.org/licenses/by-sa/4.0/) (for the media) licenses. See LICENSE and LICENSE.MEDIA for more details._


[![Please don't upload to Github](https://nogithub.codeberg.page/badge.svg)](https://nogithub.codeberg.page)  
_Due to ethical concerns, I kindly ask you not to upload this work to Github.
Thanks!_



LuaATC Textlines
----------------

This mod adds displays, inspired by those from the `textline` mod, which
support the Advtrains LuaATC system. They are in fact operation panels with
fancy displays strapped on them.


## How to use

Place a display, then right-click on it, and you will see a screen much like
the one you see with LuaATC operation panels. You can use code in it. LuaATC
Textlines will receive special `display` and `refresh` events, which frequency
can be set in the Luanti settings. Those events are only sent to a textline if
it is loaded, to avoid borking up the server.

From version β3 onwards, textlines can specify any amount of displays.

The `display()` function takes an arbitrary amount of arguments, which are the
text to display on each of the textline's displays. If there are less arguments
than the textline has displays, the unassigned displays will copy the first
one. If no text is given, forces a refresh of the textline's displays.

The default font, color, etc. can be configured in the Luanti settings.


#### Provided displays

This mod provides a flat green display, and two "hanging" displays (a green one
and an orange one). They *glow* in the dark.


#### LBM

Text is rendered on the Textlines through an entity. It is possible that, for
some reason, the entity disappears, in which case the display will be rendered
useless. For this reason, LuaATC Textline offers to register a LBM to check
for entities for every textline, and re-create an entity if a textline lacks
one. This LBM can be disabled in the Luanti settings. By default it will only
run once per textline; if you frequently delete entities (such as with
/clearobjects) you may want to run it every time a textline is loaded. (There
is an option for that.)


#### Dependencies

This mod depends on `font_api`, from the `Display modpack`, and on
`advtrains_luaautomation`, from `Advtrains`. `font_api` is not strictly needed,
but there is currently no fallback.


## How to make new LuaATC Textlines

Use `luaatc_textline.register_textline(name, def)` to register a new textline.
Then you can somewhat customize the display, e.g with color, glow, custom
entity properties (evenchanging the visual, etc), etc. See `API` for more
informations.


## Media information

Credits to Gabriel Maia and Segvault for creating the mod `textline` in first
place.

Part of the code is inspired by the original `textline` code.

Unless otherwise noted, all media were made by Nazalassa and licensed under
the CC-BY-SA-4.0 license. The following media are "otherwise noted":

* `textures/luaatc_textline_any.png` comes from `textline` and was originally
published under the WTFPL.
* `textures/luaatc_textline_background.png` comes from `textline` and was
originally published under the WTFPL.
