-- luaatc_textline/init.lua

-- The code contained in this mod is inspired by the code from mod `textline`
-- written by Gabriel Maia <gabriel@tny.im>, http://github.com/gbl08ma


local path = core.get_modpath('luaatc_textline')


luaatc_textline = {
	default_font = core.settings:get('luaatc_textline_default_font') or '',
	default_color = core.colorspec_to_colorstring(core.settings:get(
		'luaatc_textline_default_color')) or '#FFC000',
	use_font_api = core.settings:get_bool('luaatc_textline_use_font_api', true)
		and core.global_exists('font_api'),
	display_interval = core.settings:get(
		'luaatc_textline_display_interval') or 0.5,
	refresh_interval = core.settings:get(
		'luaatc_textline_refresh_interval') or 3,
}
if luaatc_textline.display_interval == 0 then
	luaatc_textline.display_interval = math.huge
end
if luaatc_textline.refresh_interval == 0 then
	luaatc_textline.refresh_interval = math.huge
end


dofile(path .. '/api.lua')
dofile(path .. '/textlines.lua')
