-- sim_trains/liveries.lua


local liveries = {}
local mod_name = "sim_trains"


-- Most of the code here was contributed by Marnack (PR #1)
-- Actually, almost all the code of this file, although I did modify it a bit.


local livery_templates = {
	["sim_trains:red_comet_front"] = {
		{
			name = "Solid Color",
			designer = "Marnack",
			texture_license = "CC-BY-SA-3.0",
			texture_creator = "Nazalassa",
			notes = "This template supports independent color overrides of the \
exterior walls and doors.",
			base_textures = {
				"st_redcom_ext.png",
				"st_redcom_int.png",
				"st_redcom_door.png",
				"st_redcom_int.png",
				"st_redcom_int.png",
				"blank.png",
				"blank.png",
				"blank.png",
				"blank.png",
				"st_redcom_ext.png",
				"st_redcom_lights_off.png",
			},
			overlays = {
				[1] = {name = "Exterior Walls", slot_idx = 1,
				       texture = "st_redcom_livery.png"},
				[2] = {name = "Doors", slot_idx = 3,
				       texture = "st_redcom_door_livery.png"},
			},
		},
	},
	["sim_trains:red_comet"] = {
		{
			name = "Solid Color",
			designer = "Marnack",
			texture_license = "CC-BY-SA-3.0",
			texture_creator = "Nazalassa ",
			notes = "This template supports independent color overrides of the \
exterior walls and doors.",
			base_textures = {
				"st_redcom_ext.png",
				"st_redcom_int.png",
				"st_redcom_door.png",
				"st_redcom_int.png",
				"st_redcom_int.png",
				"blank.png",
				"blank.png",
				"blank.png",
			},
			overlays = {
				[1] = {name = "Exterior Walls", slot_idx = 1,
				       texture = "st_redcom_livery.png"},
				[2] = {name = "Doors", slot_idx = 3,
				       texture = "st_redcom_door_livery.png"},
			},
		},
	},
}


local predefined_liveries = {
	{
		name = "Crimson Special",
		notes = "",
		livery_design = {
			livery_template_name = "Solid Color",
			overlays = {
				[1] = {id = 1,	color = "#DC143C"},	-- "Exterior Walls"
				[2] = {id = 2,	color = "#FFFFFF"},	-- "Doors"
			},
		},
	},
}


-- This function is called by the advtrains_livery_designer tool whenever the
-- player activates the "Apply" button.
-- This implementation is specific to the red_comet. A more complex
-- implementation may be needed if other wagons or livery templates are added.
-- Note: we replace "[colorize" by "[multiply" to take into account the fact
-- that the shape of the wagon makes part of its livery darker.
local function apply_wagon_livery_textures(player, wagon, textures)
	if wagon and textures and textures[1] then
		local data = advtrains.wagons[wagon.id]
		data.livery = textures[1]:gsub("%[colorize:", "[multiply:")
		data.door = textures[3]:gsub("%[colorize:", "[multiply:")
		wagon:set_textures(data)
	end
end


-- Register this mod and its livery function with the advtrains_livery_designer
-- tool.
advtrains_livery_designer.register_mod(mod_name, apply_wagon_livery_textures)


-- Register this mod's wagons and livery templates.
for wagon_type, wagon_livery_templates in pairs(livery_templates) do
	advtrains_livery_database.register_wagon(wagon_type, mod_name)
	for _, livery_template in ipairs(wagon_livery_templates) do
		advtrains_livery_database.add_livery_template(
			wagon_type,
			livery_template.name,
			livery_template.base_textures,
			mod_name,
			(livery_template.overlays and #livery_template.overlays) or 0,
			livery_template.designer,
			livery_template.texture_license,
			livery_template.texture_creator,
			livery_template.notes
		)
		if livery_template.overlays then
			for overlay_id, overlay in ipairs(livery_template.overlays) do
				advtrains_livery_database.add_livery_template_overlay(
					wagon_type,
					livery_template.name,
					overlay_id,
					overlay.name,
					overlay.slot_idx,
					overlay.texture,
					overlay.alpha
				)
			end
		end
	end
end

local wagons = {"sim_trains:red_comet_front", "sim_trains:red_comet"}

-- Register this mod's predefined wagon liveries.
for _, predefined_livery in ipairs(predefined_liveries) do
	local livery_design = predefined_livery.livery_design
	for _, wtype in ipairs(wagons) do
		livery_design.wagon_type = wtype
		advtrains_livery_database.add_predefined_livery(
			predefined_livery.name,
			livery_design,
			mod_name,
			predefined_livery.notes
		)
	end
end


function liveries.update_livery(wagon, puncher)
	local itemstack = puncher:get_wielded_item()
	local item_name = itemstack:get_name()
	if item_name == advtrains_livery_designer.tool_name then
		advtrains_livery_designer.activate_tool(puncher, wagon, mod_name)
		return 1
	end
end


return liveries
