-- sim_trains/trains.lua

local S
if minetest.get_modpath("intllib") then
    S = intllib.Getter()
else
	S = minetest.get_translator("redcom")
end

local use_attachment_patch =
	minetest.get_modpath("advtrains_attachment_offset_patch")
	and advtrains_attachment_offset_patch.setup_advtrains_wagon

local view_offset = use_attachment_patch
	and {x = 0, y = 0, z = 0}
	or {x = 0, y = 0.5, z = 0}

local info_displays =
	minetest.get_modpath("advtrains_info_displays")
	and advtrains_info_displays

local liveries =
	minetest.get_modpath("advtrains_livery_designer")
	and dofile(minetest.get_modpath("redcom") .. "/liveries.lua")


-- Gets called on punch: if we can recolor, don't destroy the wagon!
-- Note: "normal" recoloring overrides advtrains_livery_tools
local function may_destroy (self, puncher, time_from_last_punch, tool_caps,
                            direction)
	return not (self:set_livery(puncher, puncher:get_wielded_item(),
	                            advtrains.wagons[self.id])
	            or (liveries and liveries.update_livery(self, puncher)))
end



local function set_textures (self, data)
	if data.livery then
		self.livery = data.livery
		self.door_livery = data.door
	end
end

local function set_livery (self, puncher, itemstack, data)
	local color
	local name = itemstack:get_name()
	local meta = itemstack:get_meta()

	-- Try dyes
	if minetest.get_item_group(name, "dye") ~= 0 then
		for grp, _ in pairs(minetest.registered_items[name].groups) do
			if grp:find("^color_%w+$") then
				color = grp:sub(7)
				break
			end
		end

	-- Try bike:painter
	else
		local mcol = meta:get_string("paint_color")
		if mcol and mcol:find("^#%x%x%x%x%x%x$") then
			color = mcol .. ":255"
		end
	end

	if color then
		data.livery = self.base_texture .. "^(" .. self.livery_texture
		              .. "^[multiply:" .. color .. ")"
		data.door = self.door_texture .. "^(" .. self.door_livery_texture
		              .. "^[multiply:" .. color .. ":255)"
		set_textures(self, data)
		return 1
	end
end



local loco_def = {
	mesh = "st_redcom_front.b3d",
	textures = {
		"st_redcom_ext.png",
		"st_redcom_int.png",
		"st_redcom_door.png",
		"st_redcom_int.png",
		"st_redcom_ext.png",
		"blank.png",
		"blank.png",
		"blank.png",
		"blank.png",
		"st_redcom_ext.png",
		"st_redcom_lights_off.png",
	},
	info_displays = {
		line = {slot = 8, width = 32, height = 16,
		        halign = "left", bg_fit_text = true},
		front = {slot = 9, width = 160, height = 16},
		side = {slot = 6, width = 160, height = 16},
		inside_doors = {slot = 7, width = 160, height = 30},
	},
	base_texture = "st_redcom_ext.png",
	door_texture = "st_redcom_door.png",
	livery_texture = "(st_redcom_livery.png^st_redcom_seat_livery.png)",
	door_livery_texture = "st_redcom_door_livery.png",

	set_textures = set_textures,
	set_livery = set_livery,

	drives_on = {default = true},
	max_speed = 20,

	seats = {
		{
			name = "Driver stand",
			attach_offset = {x=0, y=0.5, z=24},
			view_offset = view_offset,
			group="driver_stand",
		},
		{
			name = "3",
			attach_offset = {x=-5, y=-1, z=4.78775},
			view_offset = view_offset,
			group = "middle",
		},
		{
			name = "4",
			attach_offset = {x=5, y=-1, z=4.78775},
			view_offset = view_offset,
			group = "middle",
		},
		{
			name = "5",
			attach_offset = {x=-5, y=-1, z=-4.78775},
			view_offset = view_offset,
			group = "middle",
		},
		{
			name = "6",
			attach_offset = {x=5, y=-1, z=-4.78775},
			view_offset = view_offset,
			group = "middle",
		},
		{
			name = "7",
			attach_offset = {x=-5, y=-1, z=-24.375},
			view_offset = view_offset,
			group = "back",
		},
		{
			name = "8",
			attach_offset = {x=5, y=-1, z=-24.375},
			view_offset = view_offset,
			group = "back",
		},
	},
	seat_groups = {
		driver_stand = {
			name = "Driver Stand",
			access_to = {"middle", "back"},
			require_doors_open = true,
			driving_ctrl_access = true,
		},
		middle = {
			name = "Middle",
			access_to = {"driver_stand", "back"},
			require_doors_open = true,
		},
		back = {
			name = "Back",
			access_to = {"middle"},
			require_doors_open = true,
		},
	},
	assign_to_seat_group = {"middle", "back"},

	door_entry = {1.5, -1.5},
	doors = {
		open = {
			[-1] = {frames = {x=41, y=60}, time = 1},
			[1] = {frames = {x=1, y=20}, time = 1}
		},
		close = {
			[-1] = {frames = {x=61, y=80}, time = 1},
			[1] = {frames = {x=21, y=40}, time = 1}
		}
	},
	wheel_positions = {1.35416, -1.6042},

	is_locomotive = true,
	drops = {"default:steelblock 4"},
	visual_size = {x = 1, y = 1, z = 1},
	wagon_span = 3,
	collisionbox = {
		-1.0, -0.5, -1.0,
		1.0, 2.5, 1.0
	},

	custom_may_destroy = may_destroy,

	custom_on_velocity_change = function (self, velocity, old_velocity)
		if velocity > 0 then
			advtrains.wagons[self.id]._lights =
				not advtrains.wagons[self.id].wagon_flipped
		end
	end,

	custom_on_step = info_displays and
		function (self, dtime, data, train)
			if data._reversed_cache ~= data.wagon_flipped then
				data._reversed_cache = data.wagon_flipped
				data._lights = false
			end
			self.object:set_properties{
				textures = info_displays.set_textures({
					self.livery or "st_redcom_ext.png",
					"st_redcom_int.png",
					self.door_livery or "st_redcom_door.png",
					"st_redcom_int.png",
					self.livery or "st_redcom_ext.png",
					"st_redcom_display.png",
					"st_redcom_display.png",
					"blank.png",
					"st_redcom_display.png",
					"blank.png",
					data._lights
						and "st_redcom_lights_on.png"
						or "st_redcom_lights_off.png",
				}, self, train)
			}
		end
	or
		function (self, dtime, data, train)
			if data._reversed_cache ~= data.wagon_flipped then
				data._reversed_cache = data.wagon_flipped
				data._lights = false
			end
			self.object:set_properties{
				textures = {
					self.livery or "st_redcom_ext.png",
					"st_redcom_int.png",
					self.door_livery or "st_redcom_door.png",
					"st_redcom_int.png",
					self.livery or "st_redcom_ext.png",
					"blank.png",
					"blank.png",
					"blank.png",
					"blank.png",
					"st_redcom_ext.png",
					data._lights
						and "st_redcom_lights_on.png"
						or "st_redcom_lights_off.png",
				}
			}
		end,
}



local car_def = {
	mesh = "st_redcom.b3d",
	textures = {
		"st_redcom_ext.png",
		"st_redcom_int.png",
		"st_redcom_door.png",
		"st_redcom_int.png",
		"st_redcom_ext.png",
		"blank.png",
		"blank.png",
		"blank.png",
	},
	info_displays = {
		line = {slot = 8, width = 32, height = 16,
		        halign = "left", bg_fit_text = true},
		side = {slot = 6, width = 160, height = 16},
		inside_doors = {slot = 7, width = 160, height = 30},
	},
	base_texture = "st_redcom_ext.png",
	door_texture = "st_redcom_door.png",
	livery_texture = "(st_redcom_livery.png^st_redcom_seat_livery.png)",
	door_livery_texture = "st_redcom_door_livery.png",

	set_textures = set_textures,
	set_livery = set_livery,

	drives_on = {default = true},
	max_speed = 20,

	seats = {
		{
			name = "1",
			attach_offset = {x=-5, y=-1, z=24.375},
			view_offset = view_offset,
			group = "front",
		},
		{
			name = "2",
			attach_offset = {x=5, y=-1, z=24.375},
			view_offset = view_offset,
			group = "front",
		},
		{
			name = "3",
			attach_offset = {x=-5, y=-1, z=4.78775},
			view_offset = view_offset,
			group = "middle",
		},
		{
			name = "4",
			attach_offset = {x=5, y=-1, z=4.78775},
			view_offset = view_offset,
			group = "middle",
		},
		{
			name = "5",
			attach_offset = {x=-5, y=-1, z=-4.78775},
			view_offset = view_offset,
			group = "middle",
		},
		{
			name = "6",
			attach_offset = {x=5, y=-1, z=-4.78775},
			view_offset = view_offset,
			group = "middle",
		},
		{
			name = "7",
			attach_offset = {x=-5, y=-1, z=-24.375},
			view_offset = view_offset,
			group = "back",
		},
		{
			name = "8",
			attach_offset = {x=5, y=-1, z=-24.375},
			view_offset = view_offset,
			group = "back",
		},
	},
	seat_groups = {
		front = {
			name = "Front",
			access_to = {"middle"},
			require_doors_open = true,
		},
		middle = {
			name = "Middle",
			access_to = {"front", "back"},
			require_doors_open = true,
		},
		back = {
			name = "Back",
			access_to = {"middle"},
			require_doors_open = true,
		},
	},
	assign_to_seat_group = {"middle", "front", "back"},

	door_entry = {1.5, -1.5},
	doors = {
		open = {
			[-1] = {frames = {x=41, y=60}, time = 1},
			[1] = {frames = {x=1, y=20}, time = 1}
		},
		close = {
			[-1] = {frames = {x=61, y=80}, time = 1},
			[1] = {frames = {x=21, y=40}, time = 1}
		}
	},
	wheel_positions = {1.6042, -1.6042},

	drops = {"default:steelblock 4"},
	visual_size = {x = 1, y = 1, z = 1},
	wagon_span = 3,
	collisionbox = {
		-1.0, -0.5, -1.0,
		1.0, 2.5, 1.0
	},

	custom_may_destroy = may_destroy,

	custom_on_step = info_displays and
		function (self, dtime, data, train)
			self.object:set_properties{
				textures = info_displays.set_textures({
					self.livery or "st_redcom_ext.png",
					"st_redcom_int.png",
					self.door_livery or "st_redcom_door.png",
					"st_redcom_int.png",
					self.livery or "st_redcom_ext.png",
					"st_redcom_display.png",
					"st_redcom_display.png",
					"blank.png",
				}, self, train)
			}
		end
	or
		function (self, dtime, data, train)
			self.object:set_properties{
				textures = {
					self.livery or "st_redcom_ext.png",
					"st_redcom_int.png",
					self.door_livery or "st_redcom_door.png",
					"st_redcom_int.png",
					self.livery or "st_redcom_ext.png",
					"blank.png",
					"blank.png",
					"blank.png",
				}
			}
		end,
}


if use_attachment_patch then
	advtrains_attachment_offset_patch.setup_advtrains_wagon(loco_def);
	advtrains_attachment_offset_patch.setup_advtrains_wagon(car_def);
end


advtrains.register_wagon("sim_trains:red_comet_front", loco_def,
                         S("Red Comet (front)"), "st_redcom_front_inv.png")

advtrains.register_wagon("sim_trains:red_comet", car_def,
                         S("Red Comet"), "st_redcom_inv.png")


minetest.register_craft({
	output = "sim_trains:red_comet_front",
	recipe = {
		{"default:steelblock", "default:steel_block", "default:steel_block"},
		{"default:glass", "dye:red", "default:glass"},
		{"advtrains:wheel", "", "advtrains:wheel"},
	},
})

minetest.register_craft({
	output = "sim_trains:red_comet",
	recipe = {
		{"default:steelblock", "default:steel_ingot", "default:steel_block"},
		{"default:glass", "dye:red", "default:glass"},
		{"advtrains:wheel", "", "advtrains:wheel"},
	},
})
