-- redcom_liveries/init.lua


if not minetest.get_modpath("advtrains_livery_designer") then
	return
end


-- Code copy-pasted from sim_trains/redcom/liveries.lua

local mod_name = "redcom_liveries"


local livery_templates = {
	["sim_trains:red_comet_front"] = {
		{
			name = "Bands",
			designer = "Nazalassa",
			texture_license = "CC-BY-SA-3.0",
			texture_creator = "Nazalassa",
			notes = "This template supports recoloring the exterior walls, a \
horizontal band, and vertical color bands on the doors.",
			base_textures = {
				"st_redcom_livery_ext_bands.png",
				"st_redcom_int.png",
				"st_redcom_door.png",
				"st_redcom_int.png",
				"st_redcom_livery_ext_bands.png",
				"blank.png",
				"blank.png",
				"blank.png",
				"blank.png",
				"st_redcom_livery_ext_bands.png",
				"st_redcom_lights_off.png",
			},
			overlays = {
				[1] = {name = "Exterior Walls", slot_idx = 1,
				       texture = "st_redcom_livery.png"},
				[2] = {name = "Color Band", slot_idx = 1,
				       texture = "st_redcom_livery_window_band.png"},
				[3] = {name = "Lower Color Band", slot_idx = 1,
				       texture = "st_redcom_livery_lower_band.png"},
				[4] = {name = "Seats", slot_idx = 1,
				       texture = "st_redcom_seat_livery.png"},
				[5] = {name = "Doors", slot_idx = 3,
				       texture = "st_redcom_door_livery.png"},
				[6] = {name = "Doors (bottom)", slot_idx = 3,
				       texture = "st_redcom_door_livery_lower.png"},
			},
		},
	},
	["sim_trains:red_comet"] = {
		{
			name = "Bands",
			designer = "Nazalassa",
			texture_license = "CC-BY-SA-3.0",
			texture_creator = "Nazalassa",
			notes = "This template supports recoloring the exterior walls, a \
horizontal band, and vertical color bands on the doors.",
			base_textures = {
				"st_redcom_livery_ext_bands.png",
				"st_redcom_int.png",
				"st_redcom_door.png",
				"st_redcom_int.png",
				"st_redcom_livery_ext_bands.png",
				"blank.png",
				"blank.png",
				"blank.png",
			},
			overlays = {
				[1] = {name = "Exterior Walls", slot_idx = 1,
				       texture = "st_redcom_livery.png"},
				[2] = {name = "Color Band", slot_idx = 1,
				       texture = "st_redcom_livery_window_band.png"},
				[3] = {name = "Lower Color Band", slot_idx = 1,
				       texture = "st_redcom_livery_lower_band.png"},
				[4] = {name = "Seats", slot_idx = 1,
				       texture = "st_redcom_seat_livery.png"},
				[5] = {name = "Doors", slot_idx = 3,
				       texture = "st_redcom_door_livery.png"},
				[6] = {name = "Doors (bottom)", slot_idx = 3,
				       texture = "st_redcom_door_livery_lower.png"},
			},
		},
	},
}


local predefined_liveries = {
	{
		name = "RATP Green & White",
		notes = "",
		livery_design = {
			livery_template_name = "Bands",
			overlays = {
				[1] = {id = 1,	color = "#DBDBDB"},  -- "Exterior Walls"
				[2] = {id = 2,	color = "#30A090"},  -- "Color Band"
				[3] = {id = 3, color = "#FFFFFF"},  -- "Lower Band"
				[4] = {id = 4, color = "#208070"},  -- "Seats"
				[5] = {id = 5, color = "#B0B0B0"},  -- "Doors"
				[6] = {id = 6, color = "#E0E0E0"},  -- "Doors (bottom)"
			},
		},
	},
}


advtrains_livery_database.register_mod(mod_name)


-- Register this mod's wagons and livery templates.
for wagon_type, wagon_livery_templates in pairs(livery_templates) do
	for _, livery_template in ipairs(wagon_livery_templates) do
		advtrains_livery_database.add_livery_template(
			wagon_type,
			livery_template.name,
			livery_template.base_textures,
			mod_name,
			(livery_template.overlays and #livery_template.overlays) or 0,
			livery_template.designer,
			livery_template.texture_license,
			livery_template.texture_creator,
			livery_template.notes
		)
		if livery_template.overlays then
			for overlay_id, overlay in ipairs(livery_template.overlays) do
				advtrains_livery_database.add_livery_template_overlay(
					wagon_type,
					livery_template.name,
					overlay_id,
					overlay.name,
					overlay.slot_idx,
					overlay.texture,
					overlay.alpha
				)
			end
		end
	end
end

local wagons = {"sim_trains:red_comet_front",
                "sim_trains:red_comet"}

-- Register this mod's predefined wagon liveries.
for _, predefined_livery in ipairs(predefined_liveries) do
	local livery_design = predefined_livery.livery_design
	for _, wtype in ipairs(wagons) do
		livery_design.wagon_type = wtype
		advtrains_livery_database.add_predefined_livery(
			predefined_livery.name,
			livery_design,
			mod_name,
			predefined_livery.notes
		)
	end
end
