-- sim_trains/trains.lua

local S
if minetest.get_modpath('intllib') then
	S = intllib.Getter()
else
	S = minetest.get_translator('redcom')
end

local view_offset = st_core.has_attachment_offsets
	and {x = 0, y = 0, z = 0}
	or {x = 0, y = 0.5, z = 0}

local info_displays = st_core.has_info_displays and advtrains_info_displays

local liveries = minetest.get_modpath('advtrains_livery_designer')
	and dofile(minetest.get_modpath('redcom') .. '/liveries.lua')


local set_textures = function (self, data)
	if data.livery then
		self.livery = data.livery
		self.door_livery = data.door
	end
end


st_core.register_glow_entity('redcom:glow_front', 'st_redcom_glow_front.b3d')
st_core.register_glow_entity('redcom:glow_metro', 'st_redcom_glow_metro.b3d')
st_core.register_glow_entity('redcom:glow', 'st_redcom_glow.b3d')


local loco_def = {
	mesh = 'st_redcom_front.b3d',
	textures = {
		'st_redcom_ext.png',
		'st_redcom_int.png',
		'st_redcom_door.png',
		'st_redcom_int.png',
		'st_redcom_ext.png',
		'st_redcom_ext.png',
		'st_redcom_lights_off.png',
		'blank.png',
	},
	info_displays = {
		line = {slot = 4, width = 32, height = 16, back_color = '#202020',
		        halign = 'left', bg_fit_text = true},
		front = {slot = 5, width = 160, height = 16, back_color = '#202020'},
		side = {slot = 2, width = 160, height = 16, back_color = '#202020'},
		inside_doors = {slot = 3, width = 160, height = 30,
		                back_color = '#202020'},
	},
	glow_entity = 'redcom:glow_front',
	base_texture = 'st_redcom_ext.png',
	door_texture = 'st_redcom_door.png',
	livery_texture = '(st_redcom_livery.png^st_redcom_seat_livery.png)',
	door_livery_texture = 'st_redcom_door_livery.png',

	set_textures = set_textures,
	set_livery = st_core.update_simple_livery,

	drives_on = {default = true},
	max_speed = 20,

	seats = {
		{
			name = 'Driver stand',
			attach_offset = {x=0, y=0.5, z=24},
			view_offset = view_offset,
			group = 'driver_stand',
		},
		{
			name = '3',
			attach_offset = {x=-6, y=-1, z=4.78775},
			view_offset = view_offset,
			group = 'middle',
			advtrains_attachment_offset_patch_attach_rotation =
				{x = 0, y = 90, z = 0},
		},
		{
			name = '4',
			attach_offset = {x=6, y=-1, z=4.78775},
			view_offset = view_offset,
			group = 'middle',
			advtrains_attachment_offset_patch_attach_rotation =
				{x = 0, y = -90, z = 0},
		},
		{
			name = '5',
			attach_offset = {x=-6, y=-1, z=-4.78775},
			view_offset = view_offset,
			group = 'middle',
			advtrains_attachment_offset_patch_attach_rotation =
				{x = 0, y = 90, z = 0},
		},
		{
			name = '6',
			attach_offset = {x=6, y=-1, z=-4.78775},
			view_offset = view_offset,
			group = 'middle',
			advtrains_attachment_offset_patch_attach_rotation =
				{x = 0, y = -90, z = 0},
		},
		{
			name = '7',
			attach_offset = {x=-6, y=-1, z=-24.375},
			view_offset = view_offset,
			group = 'back',
			advtrains_attachment_offset_patch_attach_rotation =
				{x = 0, y = 90, z = 0},
		},
		{
			name = '8',
			attach_offset = {x=6, y=-1, z=-24.375},
			view_offset = view_offset,
			group = 'back',
			advtrains_attachment_offset_patch_attach_rotation =
				{x = 0, y = -90, z = 0},
		},
	},
	seat_groups = {
		driver_stand = {
			name = 'Driver Stand',
			access_to = {'middle', 'back'},
			require_doors_open = true,
			driving_ctrl_access = true,
		},
		middle = {
			name = 'Middle',
			access_to = {'driver_stand', 'back'},
			require_doors_open = true,
		},
		back = {
			name = 'Back',
			access_to = {'middle'},
			require_doors_open = true,
		},
	},
	assign_to_seat_group = {'middle', 'back'},

	door_entry = {1.5, -1.5},
	doors = {
		open = {
			[-1] = {frames = {x=41, y=60}, time = 1},
			[1] = {frames = {x=1, y=20}, time = 1}
		},
		close = {
			[-1] = {frames = {x=61, y=80}, time = 1},
			[1] = {frames = {x=21, y=40}, time = 1}
		}
	},
	wheel_positions = {1.35416, -1.6042},

	is_locomotive = true,
	drops = {'default:steelblock 4'},
	visual_size = {x = 1, y = 1, z = 1},
	wagon_span = 3,
	collisionbox = {-1.0, -0.5, -1.0, 1.0, 2.5, 1.0},
	selectionbox = st_core.has_rotating_sboxes
		and {-0.875, -0.4, -2.875, 0.875, 2.125, 2.625, rotate = true}
		or {-1, -0.5, -1, 1, 2.5, 1},

	custom_may_destroy = st_core.attempt_to_set_livery,

	custom_on_velocity_change = function (self, velocity, old_velocity)
		if velocity > 0 then
			advtrains.wagons[self.id]._lights =
				not advtrains.wagons[self.id].wagon_flipped
		end
	end,

	custom_on_activate = st_core.create_glow_entity,

	custom_on_step = function (self, dtime, data, train)
		if data._reversed_cache ~= data.wagon_flipped then
			data._reversed_cache = data.wagon_flipped
			data._lights = false
		end
		self.object:set_properties{
			textures = {
				self.livery or 'st_redcom_ext.png',
				'st_redcom_int.png',
				self.door_livery or 'st_redcom_door.png',
				'st_redcom_int.png',
				self.livery or 'st_redcom_ext.png',
				info_displays
					and 'blank.png'
					or (self.livery or 'st_redcom_ext.png'),
			}
		}
		if info_displays and self.glow_object then
			self.glow_object:set_properties{
				textures = info_displays.set_textures({
					data._lights
						and 'st_redcom_lights_on.png'
						or 'st_redcom_lights_off.png',
					'st_redcom_display.png',
					'st_redcom_display.png',
					'blank.png',
					'st_redcom_display.png',
				}, self, train),
			}
		end
	end,
}


local metro_def = table.copy(loco_def)
metro_def.mesh = 'st_redcom_metro.b3d'
metro_def.max_speed = 15
metro_def.glow_entity = 'redcom:glow_metro'
metro_def.seats[1].attach_offset.y = -2


local car_def = {
	mesh = 'st_redcom.b3d',
	textures = {
		'st_redcom_ext.png',
		'st_redcom_int.png',
		'st_redcom_door.png',
		'st_redcom_int.png',
		'st_redcom_ext.png',
	},
	info_displays = {
		line = {slot = 3, width = 32, height = 16, back_color = '#202020',
		        halign = 'left', bg_fit_text = true},
		side = {slot = 1, width = 160, height = 16, back_color = '#202020'},
		inside_doors = {slot = 2, width = 160, height = 30,
		                back_color = '#202020'},
	},
	glow_entity = 'redcom:glow',
	base_texture = 'st_redcom_ext.png',
	door_texture = 'st_redcom_door.png',
	livery_texture = '(st_redcom_livery.png^st_redcom_seat_livery.png)',
	door_livery_texture = 'st_redcom_door_livery.png',

	set_textures = set_textures,
	set_livery = st_core.update_simple_livery,

	drives_on = {default = true},
	max_speed = 20,

	seats = {
		{
			name = '1',
			attach_offset = {x=-5, y=-1, z=24.375},
			view_offset = view_offset,
			group = 'front',
			advtrains_attachment_offset_patch_attach_rotation =
				{x = 0, y = 90, z = 0},
		},
		{
			name = '2',
			attach_offset = {x=5, y=-1, z=24.375},
			view_offset = view_offset,
			group = 'front',
			advtrains_attachment_offset_patch_attach_rotation =
				{x = 0, y = -90, z = 0},
		},
		{
			name = '3',
			attach_offset = {x=-5, y=-1, z=4.78775},
			view_offset = view_offset,
			group = 'middle',
			advtrains_attachment_offset_patch_attach_rotation =
				{x = 0, y = 90, z = 0},
		},
		{
			name = '4',
			attach_offset = {x=5, y=-1, z=4.78775},
			view_offset = view_offset,
			group = 'middle',
			advtrains_attachment_offset_patch_attach_rotation =
				{x = 0, y = -90, z = 0},
		},
		{
			name = '5',
			attach_offset = {x=-5, y=-1, z=-4.78775},
			view_offset = view_offset,
			group = 'middle',
			advtrains_attachment_offset_patch_attach_rotation =
				{x = 0, y = 90, z = 0},
		},
		{
			name = '6',
			attach_offset = {x=5, y=-1, z=-4.78775},
			view_offset = view_offset,
			group = 'middle',
			advtrains_attachment_offset_patch_attach_rotation =
				{x = 0, y = -90, z = 0},
		},
		{
			name = '7',
			attach_offset = {x=-5, y=-1, z=-24.375},
			view_offset = view_offset,
			group = 'back',
			advtrains_attachment_offset_patch_attach_rotation =
				{x = 0, y = 90, z = 0},
		},
		{
			name = '8',
			attach_offset = {x=5, y=-1, z=-24.375},
			view_offset = view_offset,
			group = 'back',
			advtrains_attachment_offset_patch_attach_rotation =
				{x = 0, y = -90, z = 0},
		},
	},
	seat_groups = {
		front = {
			name = 'Front',
			access_to = {'middle'},
			require_doors_open = true,
		},
		middle = {
			name = 'Middle',
			access_to = {'front', 'back'},
			require_doors_open = true,
		},
		back = {
			name = 'Back',
			access_to = {'middle'},
			require_doors_open = true,
		},
	},
	assign_to_seat_group = {'middle', 'front', 'back'},

	door_entry = {1.5, -1.5},
	doors = {
		open = {
			[-1] = {frames = {x=41, y=60}, time = 1},
			[1] = {frames = {x=1, y=20}, time = 1}
		},
		close = {
			[-1] = {frames = {x=61, y=80}, time = 1},
			[1] = {frames = {x=21, y=40}, time = 1}
		}
	},
	wheel_positions = {1.6042, -1.6042},

	drops = {'default:steelblock 4'},
	visual_size = {x = 1, y = 1, z = 1},
	wagon_span = 3,
	collisionbox = {-1.0, -0.5, -1.0, 1.0, 2.5, 1.0},
	selectionbox = st_core.has_rotating_sboxes
		and {-0.875, -0.4, -2.875, 0.875, 2.125, 2.875, rotate = true}
		or {-1, -0.5, -1, 1, 2.5, 1},

	custom_may_destroy = st_core.attempt_to_set_livery,

	custom_on_activate = st_core.create_glow_entity,

	custom_on_step = function (self, dtime, data, train)
		self.object:set_properties{
			textures = {
				self.livery or 'st_redcom_ext.png',
				'st_redcom_int.png',
				self.door_livery or 'st_redcom_door.png',
				'st_redcom_int.png',
				self.livery or 'st_redcom_ext.png',
			}
		}
		if info_displays and self.glow_object then
			self.glow_object:set_properties{
				textures = info_displays.set_textures({
					'st_redcom_display.png',
					'st_redcom_display.png',
					'blank.png',
				}, self, train)
			}
		end
	end,
}


st_core.setup_attachment_offsets(loco_def);
st_core.setup_attachment_offsets(metro_def);
st_core.setup_attachment_offsets(car_def);


advtrains.register_wagon('sim_trains:red_comet_front', loco_def,
                         S('Red Comet (front)'), 'st_redcom_front_inv.png')

advtrains.register_wagon('sim_trains:red_comet_metro', metro_def,
                         S('Red Comet (metro)'), 'st_redcom_metro_inv.png')

advtrains.register_wagon('sim_trains:red_comet', car_def,
                         S('Red Comet'), 'st_redcom_inv.png')


minetest.register_craft({
	output = 'sim_trains:red_comet_front',
	recipe = {
		{'default:steelblock', 'default:steelblock', 'default:steelblock'},
		{'default:glass',      'dye:red',            'default:glass'},
		{'advtrains:wheel',    '',                   'advtrains:wheel'},
	},
})

minetest.register_craft({
	output = 'sim_trains:red_comet_metro',
	recipe = {
		{'default:steelblock', 'default:steelblock', 'default:steel_ingot'},
		{'default:glass',      'dye:red',            'default:glass'},
		{'advtrains:wheel',    '',                   'advtrains:wheel'},
	},
})

minetest.register_craft({
	output = 'sim_trains:red_comet',
	recipe = {
		{'default:steelblock', 'default:steel_ingot', 'default:steelblock'},
		{'default:glass',      'dye:red',             'default:glass'},
		{'advtrains:wheel',    '',                    'advtrains:wheel'},
	},
})
