-- sim_trains/st_core/init.lua

st_core = {}
local livery_mod_name = 'sim_trains'

-- Let older clients and servers choose since this is client-side.
st_core.has_rotating_sboxes =
	core.settings:get_bool('sim_trains_use_rotating_sboxes', false)

-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
-- Keep it on the safe side (check everything!) --

st_core.has_attachment_offsets =
	minetest.get_modpath('advtrains_attachment_offset_patch')
	and minetest.global_exists('advtrains_attachment_offset_patch')
	and (advtrains_attachment_offset_patch.setup_advtrains_wagon ~= nil)

st_core.setup_attachment_offsets = st_core.has_attachment_offsets
	and advtrains_attachment_offset_patch.setup_advtrains_wagon
	or function () end

st_core.has_info_displays =
	minetest.get_modpath('advtrains_info_displays')
	and minetest.global_exists('advtrains_info_displays')

st_core.has_liveries =
	minetest.get_modpath('advtrains_livery_designer')
	and minetest.global_exists('advtrains_livery_designer')

if st_core.has_liveries then
	st_core.livery_mod_name = livery_mod_name
end


-- -- -- -- -- -- -- -- --
-- Common livery things --

local update_livery = st_core.has_liveries
	and function (wagon, puncher)
		local itemstack = puncher:get_wielded_item()
		local item_name = itemstack:get_name()
		if item_name == advtrains_livery_designer.tool_name then
			advtrains_livery_designer.activate_tool(puncher, wagon,
			                                        livery_mod_name)
			return true
		end
	end
	or function () end

-- Looks for the color of an item.
st_core.get_item_color = function (itemstack)
	local color
	local name = itemstack:get_name()
	local meta = itemstack:get_meta()
	-- Try dyes
	if minetest.get_item_group(name, 'dye') ~= 0 then
		for grp, _ in pairs(minetest.registered_items[name].groups) do
			if grp:find('^color_%w+$') then
				color = grp:sub(7):gsub('_', ' ')
				break
			end
		end
	-- Try bike:painter and compatibles.
	else
		local mcol = meta:get_string('paint_color')
		if mcol and mcol:find('^#%x%x%x%x%x%x$') then
			color = mcol .. ':255'
		end
	end
	return color
end

-- Local for speed.
local get_item_color = st_core.get_item_color

-- Updates a wagon's livery; requires self.base_texture, self.door_texture and
-- self.set_textures().
st_core.update_simple_livery = function (self, puncher, itemstack, data)
	local color = get_item_color(itemstack)
	if color then
		data.livery = self.base_texture .. '^(' .. self.livery_texture
		              .. '^[multiply:' .. color .. ')'
		data.door = self.door_texture .. '^(' .. self.door_livery_texture
		              .. '^[multiply:' .. color .. ')'
		self:set_textures(self, data)
		return true
	end
end

-- Out-of-the-box attempt to set a wagon's livery.
st_core.attempt_to_set_livery = function (self, puncher, time_from_last_punch,
                                          tool_caps, direction)
	return not (self.set_livery
	            and self:set_livery(puncher, puncher:get_wielded_item(),
	                                advtrains.wagons[self.id])
	            or update_livery(self, puncher))
end



-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
-- Support for glowing stuff, like lights or displays --

local make_immortal = function (self)
	self.object:set_armor_groups({immortal = 1})
end

local disappear = function (self)
	self.object:remove()
end

-- Tell Luanti we want to have our glowing entities ready.
st_core.register_glow_entity = function (name, mesh, glow_level)
	minetest.register_entity(name, {
		initial_properties = {
			physical = false,
			glow = glow_level or 8,
			textures = {'blank.png'},
			visual = 'mesh',
			mesh = mesh,
			static_save = false,
		},
		on_activate = make_immortal,
		on_detach = disappear,
	})
end

-- Out-of-the-box creation of glowing parts of the wagon.
-- Note: currently only supports one glowing thing only.
st_core.create_glow_entity = function (self)
	if self.object and self.glow_entity then
		local obj = minetest.add_entity(self.object:get_pos(), self.glow_entity)
		self.glow_object = obj
		if obj then
			obj:set_attach(self.object)
		end
	end
end
